/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.view.impl.type.LobImplementor;
import com.blazebit.persistence.view.spi.type.BasicDirtyTracker;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Blob;

public class BlobProxy
implements InvocationHandler {
    private static final Class<?>[] PROXY_INTERFACES = new Class[]{Blob.class, LobImplementor.class};
    private final Blob delegate;
    private BasicDirtyTracker parent;
    private int parentIndex = -1;
    private boolean dirty;

    public BlobProxy(Blob delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "getWrapped": {
                return this.delegate;
            }
            case "$$_isDirty": {
                return this.dirty;
            }
            case "$$_unmarkDirty": {
                this.dirty = false;
                return null;
            }
            case "$$_setParent": {
                if (this.parent != null) {
                    throw new IllegalStateException("Parent object for " + this.toString() + " is already set to " + this.parent.toString() + " and can't be set to:" + this.parent.toString());
                }
                this.parent = (BasicDirtyTracker)args[0];
                this.parentIndex = (Integer)args[1];
                return null;
            }
            case "$$_unsetParent": {
                this.parent = null;
                this.parentIndex = -1;
                return null;
            }
            case "$$_markDirty": {
                this.dirty = true;
                return null;
            }
            case "setBytes": 
            case "setBinaryStream": 
            case "truncate": {
                this.dirty = true;
                if (this.parent == null) break;
                this.parent.$$_markDirty(this.parentIndex);
                break;
            }
            case "toString": {
                return this.toString();
            }
            case "equals": {
                return this == args[0];
            }
            case "hashCode": {
                return this.hashCode();
            }
        }
        return method.invoke((Object)this.delegate, args);
    }

    public static Blob generateProxy(Blob delegate) {
        if (delegate == null) {
            return null;
        }
        return (Blob)Proxy.newProxyInstance(BlobProxy.class.getClassLoader(), PROXY_INTERFACES, (InvocationHandler)new BlobProxy(delegate));
    }
}

