/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.view.impl.type.AbstractInstantTypeConverter;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class CalendarToInstantTypeConverter<T extends Calendar>
extends AbstractInstantTypeConverter<T> {
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    public static final CalendarToInstantTypeConverter<Calendar> JAVA_UTIL_CALENDAR_CONVERTER = new CalendarToInstantTypeConverter<Calendar>(){

        public Class<?> getUnderlyingType(Class<?> owningClass, Type declaredType) {
            return Calendar.class;
        }

        public Calendar convertToUnderlyingType(Object object) {
            if (object == null) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeZone(UTC_TIMEZONE);
            calendar.setTimeInMillis(this.toEpochMillis(object));
            return calendar;
        }
    };
    public static final CalendarToInstantTypeConverter<GregorianCalendar> JAVA_UTIL_GREGORIAN_CALENDAR_CONVERTER = new CalendarToInstantTypeConverter<GregorianCalendar>(){

        public Class<?> getUnderlyingType(Class<?> owningClass, Type declaredType) {
            return GregorianCalendar.class;
        }

        public GregorianCalendar convertToUnderlyingType(Object object) {
            if (object == null) {
                return null;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeZone(UTC_TIMEZONE);
            gregorianCalendar.setTimeInMillis(this.toEpochMillis(object));
            return gregorianCalendar;
        }
    };

    public Object convertToViewType(Calendar object) {
        if (object == null) {
            return null;
        }
        return this.ofEpochMilli(object.getTimeInMillis());
    }
}

