/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.parser.CharSequenceUtils;
import com.blazebit.persistence.view.spi.type.BasicUserType;
import java.sql.Time;
import java.util.Calendar;

public class TimeBasicUserType
implements BasicUserType<Time> {
    public static final BasicUserType<?> INSTANCE = new TimeBasicUserType();

    public boolean isMutable() {
        return true;
    }

    public boolean supportsDirtyChecking() {
        return false;
    }

    public boolean supportsDirtyTracking() {
        return false;
    }

    public boolean supportsDeepEqualChecking() {
        return true;
    }

    public boolean supportsDeepCloning() {
        return true;
    }

    public boolean isEqual(Time initial, Time current) {
        return initial.getTime() == current.getTime();
    }

    public boolean isDeepEqual(Time initial, Time current) {
        return initial.getTime() == current.getTime();
    }

    public int hashCode(Time object) {
        return object.hashCode();
    }

    public boolean shouldPersist(Time entity) {
        return false;
    }

    public String[] getDirtyProperties(Time entity) {
        return DIRTY_MARKER;
    }

    public Time deepClone(Time object) {
        return (Time)object.clone();
    }

    public Time fromString(CharSequence sequence) {
        int fractionDot = CharSequenceUtils.lastIndexOf((CharSequence)sequence, (char)'.');
        if (fractionDot == -1) {
            return Time.valueOf(sequence.toString());
        }
        int millisEndIndex = fractionDot + 4;
        Time t = Time.valueOf(sequence.subSequence(0, fractionDot).toString());
        Calendar c = Calendar.getInstance();
        c.setTime(t);
        String fractions = sequence.subSequence(fractionDot + 1, millisEndIndex).toString();
        c.set(14, Integer.parseInt(fractions));
        return new Time(c.getTimeInMillis());
    }

    public String toStringExpression(String expression) {
        return "TIME_ISO(" + expression + ")";
    }
}

