/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update;

import com.blazebit.persistence.view.PostCommitListener;
import com.blazebit.persistence.view.PostPersistEntityListener;
import com.blazebit.persistence.view.PostPersistListener;
import com.blazebit.persistence.view.PostRemoveListener;
import com.blazebit.persistence.view.PostRollbackListener;
import com.blazebit.persistence.view.PostUpdateListener;
import com.blazebit.persistence.view.PrePersistEntityListener;
import com.blazebit.persistence.view.PrePersistListener;
import com.blazebit.persistence.view.PreRemoveListener;
import com.blazebit.persistence.view.PreUpdateListener;
import com.blazebit.persistence.view.ViewTransition;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.update.Listeners;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import com.blazebit.persistence.view.spi.type.MutableStateTrackable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;

public class ListenerManager {
    private final EntityViewManagerImpl evm;
    private final Map<Class<?>, Listeners> listeners;
    private final Map<Class<?>, Listeners> customListeners;

    public ListenerManager(EntityViewManagerImpl evm) {
        this.evm = evm;
        this.listeners = evm.getListeners();
        this.customListeners = new HashMap();
    }

    public void onPrePersist(ManagedViewType<?> managedViewType, Class<?> entityClass, PrePersistListener<?> listener) {
        Class entityViewClass = managedViewType.getJavaType();
        for (Class<?> javaType : this.evm.getJavaTypeToManagedTypeJavaTypes(entityClass)) {
            Listeners listeners = this.customListeners.get(javaType);
            if (listeners == null) {
                listeners = new Listeners(javaType);
                this.customListeners.put(javaType, listeners);
            }
            listeners.addPrePersistListener(entityViewClass, listener);
        }
    }

    public void onPrePersist(ManagedViewType<?> managedViewType, Class<?> entityClass, PrePersistEntityListener<?, ?> listener) {
        Class entityViewClass = managedViewType.getJavaType();
        for (Class<?> javaType : this.evm.getJavaTypeToManagedTypeJavaTypes(entityClass)) {
            Listeners listeners = this.customListeners.get(javaType);
            if (listeners == null) {
                listeners = new Listeners(javaType);
                this.customListeners.put(javaType, listeners);
            }
            listeners.addPrePersistEntityListener(entityViewClass, listener);
        }
    }

    public void onPostPersist(ManagedViewType<?> managedViewType, Class<?> entityClass, PostPersistListener<?> listener) {
        Class entityViewClass = managedViewType.getJavaType();
        for (Class<?> javaType : this.evm.getJavaTypeToManagedTypeJavaTypes(entityClass)) {
            Listeners listeners = this.customListeners.get(javaType);
            if (listeners == null) {
                listeners = new Listeners(javaType);
                this.customListeners.put(javaType, listeners);
            }
            listeners.addPostPersistListener(entityViewClass, listener);
        }
    }

    public void onPostPersist(ManagedViewType<?> managedViewType, Class<?> entityClass, PostPersistEntityListener<?, ?> listener) {
        Class entityViewClass = managedViewType.getJavaType();
        for (Class<?> javaType : this.evm.getJavaTypeToManagedTypeJavaTypes(entityClass)) {
            Listeners listeners = this.customListeners.get(javaType);
            if (listeners == null) {
                listeners = new Listeners(javaType);
                this.customListeners.put(javaType, listeners);
            }
            listeners.addPostPersistEntityListener(entityViewClass, listener);
        }
    }

    public void onPreUpdate(ManagedViewType<?> managedViewType, Class<?> entityClass, PreUpdateListener<?> listener) {
        Class entityViewClass = managedViewType.getJavaType();
        for (Class<?> javaType : this.evm.getJavaTypeToManagedTypeJavaTypes(entityClass)) {
            Listeners listeners = this.customListeners.get(javaType);
            if (listeners == null) {
                listeners = new Listeners(javaType);
                this.customListeners.put(javaType, listeners);
            }
            listeners.addPreUpdateListener(entityViewClass, listener);
        }
    }

    public void onPostUpdate(ManagedViewType<?> managedViewType, Class<?> entityClass, PostUpdateListener<?> listener) {
        Class entityViewClass = managedViewType.getJavaType();
        for (Class<?> javaType : this.evm.getJavaTypeToManagedTypeJavaTypes(entityClass)) {
            Listeners listeners = this.customListeners.get(javaType);
            if (listeners == null) {
                listeners = new Listeners(javaType);
                this.customListeners.put(javaType, listeners);
            }
            listeners.addPostUpdateListener(entityViewClass, listener);
        }
    }

    public void onPreRemove(ManagedViewType<?> managedViewType, Class<?> entityClass, PreRemoveListener<?> listener) {
        Class entityViewClass = managedViewType.getJavaType();
        for (Class<?> javaType : this.evm.getJavaTypeToManagedTypeJavaTypes(entityClass)) {
            Listeners listeners = this.customListeners.get(javaType);
            if (listeners == null) {
                listeners = new Listeners(javaType);
                this.customListeners.put(javaType, listeners);
            }
            listeners.addPreRemoveListener(entityViewClass, listener);
        }
    }

    public void onPostRemove(ManagedViewType<?> managedViewType, Class<?> entityClass, PostRemoveListener<?> listener) {
        Class entityViewClass = managedViewType.getJavaType();
        for (Class<?> javaType : this.evm.getJavaTypeToManagedTypeJavaTypes(entityClass)) {
            Listeners listeners = this.customListeners.get(javaType);
            if (listeners == null) {
                listeners = new Listeners(javaType);
                this.customListeners.put(javaType, listeners);
            }
            listeners.addPostRemoveListener(entityViewClass, listener);
        }
    }

    public void onPostCommit(ManagedViewType<?> managedViewType, Class<?> entityClass, PostCommitListener<?> listener, Set<ViewTransition> viewTransitions) {
        Class entityViewClass = managedViewType.getJavaType();
        for (Class<?> javaType : this.evm.getJavaTypeToManagedTypeJavaTypes(entityClass)) {
            Listeners listeners = this.customListeners.get(javaType);
            if (listeners == null) {
                listeners = new Listeners(javaType);
                this.customListeners.put(javaType, listeners);
            }
            listeners.addPostCommitListener(entityViewClass, listener, viewTransitions);
        }
    }

    public void onPostRollback(ManagedViewType<?> managedViewType, Class<?> entityClass, PostRollbackListener<?> listener, Set<ViewTransition> viewTransitions) {
        Class entityViewClass = managedViewType.getJavaType();
        for (Class<?> javaType : this.evm.getJavaTypeToManagedTypeJavaTypes(entityClass)) {
            Listeners listeners = this.customListeners.get(javaType);
            if (listeners == null) {
                listeners = new Listeners(javaType);
                this.customListeners.put(javaType, listeners);
            }
            listeners.addPostRollbackListener(entityViewClass, listener, viewTransitions);
        }
    }

    public boolean hasPostCommitListeners() {
        for (Listeners listener : this.listeners.values()) {
            if (!listener.hasPostCommitListeners()) continue;
            return true;
        }
        for (Listeners listener : this.customListeners.values()) {
            if (!listener.hasPostCommitListeners()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPostRollbackListeners() {
        for (Listeners listener : this.listeners.values()) {
            if (!listener.hasPostRollbackListeners()) continue;
            return true;
        }
        for (Listeners listener : this.customListeners.values()) {
            if (!listener.hasPostRollbackListeners()) continue;
            return true;
        }
        return false;
    }

    public boolean hasRemoveListeners(Class<?> entityClass) {
        Listeners listeners = this.listeners.get(entityClass);
        if (listeners != null && listeners.hasRemoveListeners()) {
            return true;
        }
        listeners = this.customListeners.get(entityClass);
        return listeners != null && listeners.hasRemoveListeners();
    }

    public boolean hasPossiblyCancellingRemoveListeners(Class<?> entityClass) {
        Listeners listeners = this.listeners.get(entityClass);
        if (listeners != null && listeners.hasPossiblyCancellingRemoveListeners()) {
            return true;
        }
        listeners = this.customListeners.get(entityClass);
        return listeners != null && listeners.hasPossiblyCancellingRemoveListeners();
    }

    public void invokePrePersist(UpdateContext context, MutableStateTrackable updatableProxy, Object entity) {
        ManagedViewType managedView = this.evm.getMetamodel().managedView(updatableProxy.$$_getEntityViewClass());
        Listeners listeners = this.listeners.get(managedView.getJavaType());
        if (listeners != null) {
            listeners.invokePrePersist(context, (EntityViewProxy)updatableProxy, entity);
        }
        if ((listeners = this.listeners.get(managedView.getEntityClass())) != null) {
            listeners.invokePrePersist(context, (EntityViewProxy)updatableProxy, entity);
        }
        if ((listeners = this.customListeners.get(managedView.getEntityClass())) != null) {
            listeners.invokePrePersist(context, (EntityViewProxy)updatableProxy, entity);
        }
    }

    public void invokePostPersist(UpdateContext context, MutableStateTrackable updatableProxy, Object entity) {
        ManagedViewType managedView = this.evm.getMetamodel().managedView(updatableProxy.$$_getEntityViewClass());
        Listeners listeners = this.listeners.get(managedView.getJavaType());
        if (listeners != null) {
            listeners.invokePostPersist(context, (EntityViewProxy)updatableProxy, entity);
        }
        if ((listeners = this.listeners.get(managedView.getEntityClass())) != null) {
            listeners.invokePostPersist(context, (EntityViewProxy)updatableProxy, entity);
        }
        if ((listeners = this.customListeners.get(managedView.getEntityClass())) != null) {
            listeners.invokePostPersist(context, (EntityViewProxy)updatableProxy, entity);
        }
    }

    public boolean invokePreUpdate(UpdateContext context, MutableStateTrackable updatableProxy) {
        ManagedViewType managedView = this.evm.getMetamodel().managedView(updatableProxy.$$_getEntityViewClass());
        Listeners listeners = this.listeners.get(managedView.getJavaType());
        boolean ranAny = false;
        if (listeners != null) {
            ranAny |= listeners.invokePreUpdate(context, (EntityViewProxy)updatableProxy);
        }
        if ((listeners = this.listeners.get(managedView.getEntityClass())) != null) {
            ranAny |= listeners.invokePreUpdate(context, (EntityViewProxy)updatableProxy);
        }
        if ((listeners = this.customListeners.get(managedView.getEntityClass())) != null) {
            ranAny |= listeners.invokePreUpdate(context, (EntityViewProxy)updatableProxy);
        }
        return ranAny;
    }

    public void invokePostUpdate(UpdateContext context, MutableStateTrackable updatableProxy) {
        ManagedViewType managedView = this.evm.getMetamodel().managedView(updatableProxy.$$_getEntityViewClass());
        Listeners listeners = this.listeners.get(managedView.getJavaType());
        if (listeners != null) {
            listeners.invokePostUpdate(context, (EntityViewProxy)updatableProxy);
        }
        if ((listeners = this.listeners.get(managedView.getEntityClass())) != null) {
            listeners.invokePostUpdate(context, (EntityViewProxy)updatableProxy);
        }
        if ((listeners = this.customListeners.get(managedView.getEntityClass())) != null) {
            listeners.invokePostUpdate(context, (EntityViewProxy)updatableProxy);
        }
    }

    public boolean invokePreRemove(UpdateContext context, EntityViewProxy entityView, Class<?> entityClass, Object entityId) {
        Listeners listeners;
        ManagedViewType managedView = null;
        if (entityView != null) {
            managedView = this.evm.getMetamodel().managedView(entityView.$$_getEntityViewClass());
            entityClass = managedView.getEntityClass();
            listeners = this.listeners.get(managedView.getJavaType());
            if (listeners != null && !listeners.invokePreRemove(context, entityView, entityId)) {
                return false;
            }
        }
        if ((listeners = this.listeners.get(entityClass)) != null && !listeners.invokePreRemove(context, entityView, entityId)) {
            return false;
        }
        listeners = this.customListeners.get(entityClass);
        if (listeners != null && !listeners.invokePreRemove(context, entityView, entityId)) {
            return false;
        }
        if (managedView != null && (listeners = this.listeners.get(managedView.getJavaType())) != null) {
            listeners.preparePostRemove(context, entityView, entityId);
        }
        if ((listeners = this.listeners.get(entityClass)) != null) {
            listeners.preparePostRemove(context, entityView, entityId);
        }
        if ((listeners = this.customListeners.get(entityClass)) != null) {
            listeners.preparePostRemove(context, entityView, entityId);
        }
        return true;
    }

    public void invokePostRemove(UpdateContext context, EntityViewProxy entityView, Class<?> entityClass, Object entityId) {
        Listeners listeners;
        if (entityView != null) {
            ManagedViewType managedView = this.evm.getMetamodel().managedView(entityView.$$_getEntityViewClass());
            entityClass = managedView.getEntityClass();
            listeners = this.listeners.get(managedView.getJavaType());
            if (listeners != null) {
                listeners.invokePostRemove(context, entityView, entityId);
            }
        }
        if ((listeners = this.listeners.get(entityClass)) != null) {
            listeners.invokePostRemove(context, entityView, entityId);
        }
        if ((listeners = this.customListeners.get(entityClass)) != null) {
            listeners.invokePostRemove(context, entityView, entityId);
        }
    }

    public void invokePostCommit(UpdateContext context, EntityViewProxy entityView, ViewTransition viewTransition) {
        ManagedViewType managedView = this.evm.getMetamodel().managedView(entityView.$$_getEntityViewClass());
        Listeners listeners = this.listeners.get(managedView.getJavaType());
        if (listeners != null) {
            listeners.invokePostCommit(context, entityView, viewTransition);
        }
        if ((listeners = this.listeners.get(managedView.getEntityClass())) != null) {
            listeners.invokePostCommit(context, entityView, viewTransition);
        }
        if ((listeners = this.customListeners.get(managedView.getEntityClass())) != null) {
            listeners.invokePostCommit(context, entityView, viewTransition);
        }
    }

    public void invokePostRollback(UpdateContext context, EntityViewProxy entityView, ViewTransition viewTransition, EntityManager em) {
        ManagedViewType managedView = this.evm.getMetamodel().managedView(entityView.$$_getEntityViewClass());
        Listeners listeners = this.listeners.get(managedView.getJavaType());
        if (listeners != null) {
            listeners.invokePostRollback(context, entityView, viewTransition, em);
        }
        if ((listeners = this.listeners.get(managedView.getEntityClass())) != null) {
            listeners.invokePostRollback(context, entityView, viewTransition, em);
        }
        if ((listeners = this.customListeners.get(managedView.getEntityClass())) != null) {
            listeners.invokePostRollback(context, entityView, viewTransition, em);
        }
    }
}

