/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.Accessors;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.mapper.Mapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.UpdateQueryFactory;
import com.blazebit.persistence.view.impl.update.flush.BasicAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.TypeDescriptor;
import com.blazebit.persistence.view.impl.update.flush.UnmappedOwnerAwareDeleter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Query;

public class ParentReferenceAttributeFlusher<E, V>
extends BasicAttributeFlusher<E, V> {
    private final Map<String, String> writableMappings;
    private final Mapper<V, E> mapper;
    private final String[] updateQueryFragments;
    private final Map.Entry<String, AttributeAccessor>[] parameterAccessors;

    public ParentReferenceAttributeFlusher(EntityViewManagerImpl evm, Class<?> parentEntityClass, String attributeName, String mapping, Map<String, String> writableMappings, TypeDescriptor typeDescriptor, AttributeAccessor attributeAccessor, Mapper<V, E> mapper) {
        super(attributeName, mapping, true, false, true, false, false, false, null, evm.getJpaProvider(), typeDescriptor, mapping, mapping, attributeAccessor, null, null, null, null);
        this.writableMappings = writableMappings;
        this.mapper = mapper;
        if (writableMappings != null) {
            ArrayList<String> fragments = new ArrayList<String>(writableMappings.size() * 2);
            HashMap<String, AttributeAccessor> accessors = new HashMap<String, AttributeAccessor>(writableMappings.size());
            for (Map.Entry<String, String> entry : writableMappings.entrySet()) {
                String s = entry.getValue();
                String parameterName = s.replace('.', '_');
                fragments.add(s);
                fragments.add(parameterName);
                accessors.put(parameterName, Accessors.forEntityMapping(evm, parentEntityClass, entry.getKey()));
            }
            this.updateQueryFragments = fragments.toArray(new String[fragments.size()]);
            this.parameterAccessors = accessors.entrySet().toArray(new Map.Entry[accessors.size()]);
        } else {
            this.updateQueryFragments = null;
            this.parameterAccessors = null;
        }
    }

    @Override
    public boolean appendUpdateQueryFragment(UpdateContext context, StringBuilder sb, String mappingPrefix, String parameterPrefix, String separator) {
        if (this.writableMappings != null) {
            if (mappingPrefix == null) {
                sb.append(this.updateQueryFragments[0]);
                sb.append(" = :");
                sb.append(this.updateQueryFragments[1]);
                for (int i = 2; i < this.updateQueryFragments.length; i += 2) {
                    sb.append(separator);
                    sb.append(this.updateQueryFragments[i]);
                    sb.append(" = :");
                    sb.append(this.updateQueryFragments[i + 1]);
                }
            } else {
                sb.append(mappingPrefix).append(this.updateQueryFragments[0]);
                sb.append(" = :");
                sb.append(parameterPrefix).append(this.updateQueryFragments[1]);
                for (int i = 2; i < this.updateQueryFragments.length; i += 2) {
                    sb.append(separator);
                    sb.append(mappingPrefix).append(this.updateQueryFragments[i]);
                    sb.append(" = :");
                    sb.append(parameterPrefix).append(this.updateQueryFragments[i + 1]);
                }
            }
            return true;
        }
        return super.appendUpdateQueryFragment(context, sb, mappingPrefix, parameterPrefix, separator);
    }

    @Override
    public Query flushQuery(UpdateContext context, String parameterPrefix, UpdateQueryFactory queryFactory, Query query, Object ownerView, Object view, V value, UnmappedOwnerAwareDeleter ownerAwareDeleter, DirtyAttributeFlusher<?, ?, ?> ownerFlusher) {
        if (query != null && this.writableMappings != null) {
            for (int i = 0; i < this.parameterAccessors.length; ++i) {
                Map.Entry<String, AttributeAccessor> parameterAccessor = this.parameterAccessors[i];
                String parameter = parameterPrefix == null ? parameterAccessor.getKey() : parameterPrefix + parameterAccessor.getKey();
                query.setParameter(parameter, parameterAccessor.getValue().getValue(value));
            }
        } else {
            super.flushQuery(context, parameterPrefix, queryFactory, query, ownerView, view, value, ownerAwareDeleter, ownerFlusher);
        }
        return query;
    }

    @Override
    public boolean flushEntity(UpdateContext context, E entity, Object ownerView, Object view, V value, Runnable postReplaceListener) {
        this.mapper.map(value, entity);
        return true;
    }
}

