/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.storage.modules.storage.nio2;

import com.blazebit.storage.core.api.StorageException;
import com.blazebit.storage.core.api.spi.StorageProvider;
import com.blazebit.storage.core.api.spi.StorageResult;
import com.blazebit.storage.modules.storage.base.AbstractStorageProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Nio2StorageProvider
extends AbstractStorageProvider
implements StorageProvider {
    private static final Logger LOG = Logger.getLogger(Nio2StorageProvider.class.getName());
    private static final int CREATE_RETRIES = 3;

    protected abstract Path getBasePath();

    protected FileStore getFileStore() throws IOException {
        Path basePath = this.getBasePath();
        return basePath.getFileSystem().provider().getFileStore(basePath);
    }

    protected Path getObjectPath(String externalKey) {
        return this.getBasePath().resolve(externalKey);
    }

    public Object getStorageIdentifier() {
        return this.getBasePath();
    }

    protected Path createTempFile() throws IOException {
        return Files.createTempFile(this.getBasePath(), null, null, new FileAttribute[0]);
    }

    public InputStream getObject(String externalKey) {
        Path objectPath = this.getObjectPath(externalKey);
        try {
            return Files.newInputStream(objectPath, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteObject(String externalKey) {
        Path objectPath = this.getObjectPath(externalKey);
        try {
            Files.deleteIfExists(objectPath);
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public StorageResult createObject(InputStream content) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[CATCHBLOCK]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public StorageResult putObject(String externalKey, InputStream content) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Path objectPath = this.getObjectPath(externalKey);
        Path tempPath = null;
        try {
            StorageResult storageResult;
            tempPath = this.createTempFile();
            try (OutputStream os = Files.newOutputStream(tempPath, StandardOpenOption.WRITE);){
                storageResult = Nio2StorageProvider.copyWithChecksum((MessageDigest)md, (InputStream)content, (OutputStream)os);
            }
            Files.move(tempPath, objectPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            os = storageResult.withExternalKey(externalKey);
            return os;
        }
        catch (IOException e) {
            if (objectPath != null) {
                try {
                    Files.deleteIfExists(objectPath);
                }
                catch (IOException ex) {
                    ex.addSuppressed(e);
                    LOG.log(Level.SEVERE, "Could not delete file after IO error!", ex);
                }
            }
            throw new StorageException((Throwable)e);
        }
        finally {
            if (tempPath != null) {
                try {
                    Files.deleteIfExists(tempPath);
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Could not delete temporary file!", e);
                }
            }
        }
    }

    public StorageResult copyObject(StorageProvider sourceStorageProvider, String contentKey) {
        if (this.getStorageIdentifier().equals(sourceStorageProvider.getStorageIdentifier())) {
            Path sourceObjectPath = this.getObjectPath(contentKey);
            try {
                int retries = 3;
                FileAlreadyExistsException retryException = null;
                while (retries-- != 0) {
                    Path objectPath = null;
                    try {
                        String externalKey = UUID.randomUUID().toString();
                        objectPath = this.getObjectPath(externalKey);
                        Files.copy(sourceObjectPath, objectPath, new CopyOption[0]);
                        return new StorageResult(externalKey, null, -1L);
                    }
                    catch (FileAlreadyExistsException ex) {
                        retryException = ex;
                    }
                    catch (IOException ex) {
                        if (objectPath != null) {
                            Files.deleteIfExists(objectPath);
                        }
                        throw ex;
                    }
                }
                throw new StorageException("Could not copy object. Tried 3 times!", retryException);
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }
        return super.copyObject(sourceStorageProvider, contentKey);
    }

    public long getTotalSpace() {
        try {
            return this.getFileStore().getTotalSpace();
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public long getUsableSpace() {
        try {
            return this.getFileStore().getUsableSpace();
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public long getUnallocatedSpace() {
        try {
            return this.getFileStore().getUnallocatedSpace();
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public boolean supportsDelete() {
        return true;
    }

    public boolean supportsPut() {
        return true;
    }
}

