/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.weblink.modules.dispatcher.base;

import com.blazebit.weblink.core.api.spi.ConfigurationElement;
import com.blazebit.weblink.core.api.spi.ProviderMetamodel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DefaultProviderMetamodel
implements ProviderMetamodel {
    private final String key;
    private final String name;
    private final String description;
    private final Set<ConfigurationElement> configurationElements;
    private final Map<String, ConfigurationElement> configurationElementMap;

    public DefaultProviderMetamodel(String key, String name, String description, ConfigurationElement ... configurationElements) {
        this(key, name, description, new LinkedHashSet<ConfigurationElement>(Arrays.asList(configurationElements)));
    }

    public DefaultProviderMetamodel(String scheme, String name, String description, Set<ConfigurationElement> configurationElements) {
        this.key = scheme;
        this.name = name;
        this.description = description;
        LinkedHashSet<ConfigurationElement> set = new LinkedHashSet<ConfigurationElement>();
        HashMap<String, ConfigurationElement> map = new HashMap<String, ConfigurationElement>(configurationElements.size());
        for (ConfigurationElement element : configurationElements) {
            set.add(element);
            map.put(element.getKey(), element);
        }
        this.configurationElements = Collections.unmodifiableSet(set);
        this.configurationElementMap = Collections.unmodifiableMap(map);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ConfigurationElement getConfigurationElement(String key) {
        return this.configurationElementMap.get(key);
    }

    public Set<ConfigurationElement> getConfigurationElements() {
        return this.configurationElements;
    }
}

