/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.impl.ContinuationGroup;
import com.cloudbees.groovy.cps.impl.ContinuationPtr;
import com.cloudbees.groovy.cps.impl.ReferenceStackTrace;
import com.cloudbees.groovy.cps.impl.SourceLocation;
import java.util.ArrayList;
import java.util.Arrays;

public class FunctionCallBlock
implements Block {
    private final Block lhsExp;
    private final Block nameExp;
    private final Block[] argExps;
    private final SourceLocation loc;
    private final boolean safe;
    static final ContinuationPtr fixLhs = new ContinuationPtr(ContinuationImpl.class, "fixLhs");
    static final ContinuationPtr fixName = new ContinuationPtr(ContinuationImpl.class, "fixName");
    static final ContinuationPtr fixArg = new ContinuationPtr(ContinuationImpl.class, "fixArg");
    private static final long serialVersionUID = 1L;

    public FunctionCallBlock(SourceLocation loc, Block lhsExp, Block nameExp, boolean safe, Block[] argExps) {
        this.loc = loc;
        this.lhsExp = lhsExp;
        this.nameExp = nameExp;
        this.safe = safe;
        this.argExps = argExps;
    }

    public Next eval(Env e, Continuation k) {
        return new ContinuationImpl(e, k).then(this.lhsExp, e, fixLhs);
    }

    private void fillInStackTrace(Env e, Throwable t) {
        ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>();
        stack.add((this.loc != null ? this.loc : SourceLocation.UNKNOWN).toStackTrace());
        e.buildStackTraceElements(stack, Integer.MAX_VALUE);
        stack.add(Continuable.SEPARATOR_STACK_ELEMENT);
        stack.addAll(Arrays.asList(t.getStackTrace()));
        t.setStackTrace(stack.toArray(new StackTraceElement[stack.size()]));
    }

    class ContinuationImpl
    extends ContinuationGroup {
        final Continuation k;
        final Env e;
        Object lhs;
        String name;
        Object[] args;
        int idx;
        private static final long serialVersionUID = 1L;

        ContinuationImpl(Env e, Continuation k) {
            this.args = new Object[FunctionCallBlock.this.argExps.length];
            this.e = e;
            this.k = k;
        }

        public Next fixLhs(Object lhs) {
            this.lhs = lhs;
            return this.then(FunctionCallBlock.this.nameExp, this.e, fixName);
        }

        public Next fixName(Object name) {
            this.name = name.toString();
            return this.dispatchOrArg();
        }

        public Next fixArg(Object v) {
            this.args[this.idx++] = v;
            return this.dispatchOrArg();
        }

        private Next dispatchOrArg() {
            if (this.args.length > this.idx) {
                return this.then(FunctionCallBlock.this.argExps[this.idx], this.e, fixArg);
            }
            if (this.name.equals("<init>")) {
                Object v;
                try {
                    v = this.e.getInvoker().constructorCall((Class)this.lhs, this.args);
                }
                catch (Throwable t) {
                    return this.throwException(this.e, t, FunctionCallBlock.this.loc, new ReferenceStackTrace());
                }
                if (v instanceof Throwable) {
                    FunctionCallBlock.this.fillInStackTrace(this.e, (Throwable)v);
                }
                return this.k.receive(v);
            }
            if (FunctionCallBlock.this.safe && this.lhs == null) {
                return this.k.receive(null);
            }
            return this.methodCall(this.e, FunctionCallBlock.this.loc, this.k, this.lhs, this.name, this.args);
        }
    }
}

