/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.tlv;

import com.cloudhopper.commons.util.ByteArrayUtil;
import com.cloudhopper.commons.util.HexUtil;
import com.cloudhopper.smpp.tlv.TlvConvertException;
import java.io.UnsupportedEncodingException;

public class Tlv {
    private final short tag;
    private final byte[] value;
    private String tagName;

    public Tlv(short tag, byte[] value) {
        this(tag, value, null);
    }

    public Tlv(short tag, byte[] value, String tagName) {
        this.tag = tag;
        this.value = value;
        this.tagName = tagName;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String value) {
        this.tagName = value;
    }

    public short getTag() {
        return this.tag;
    }

    public int getUnsignedLength() {
        return this.value == null ? 0 : this.value.length;
    }

    public short getLength() {
        return (short)this.getUnsignedLength();
    }

    public byte[] getValue() {
        return this.value;
    }

    public int calculateByteSize() {
        return 4 + this.getUnsignedLength();
    }

    public String getValueAsString() throws TlvConvertException {
        return this.getValueAsString("ISO-8859-1");
    }

    public String getValueAsString(String charsetName) throws TlvConvertException {
        if (this.value == null) {
            return null;
        }
        if (this.value.length == 0) {
            return "";
        }
        int len = this.value.length;
        for (int i = 0; i < this.value.length; ++i) {
            if (this.value[i] != 0) continue;
            len = i;
            break;
        }
        try {
            return new String(this.value, 0, len, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new TlvConvertException("String", "unsupported charset " + e.getMessage());
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(40);
        if (this.tagName != null) {
            buffer.append(this.tagName);
        } else {
            buffer.append("tlv");
        }
        buffer.append(": 0x");
        buffer.append(HexUtil.toHexString((short)this.tag));
        buffer.append(" 0x");
        buffer.append(HexUtil.toHexString((short)((short)this.getUnsignedLength())));
        buffer.append(" [");
        HexUtil.appendHexString((StringBuilder)buffer, (byte[])this.value);
        buffer.append("]");
        return buffer.toString();
    }

    public byte getValueAsByte() throws TlvConvertException {
        try {
            return ByteArrayUtil.toByte((byte[])this.value);
        }
        catch (IllegalArgumentException e) {
            throw new TlvConvertException("byte", e.getMessage());
        }
    }

    public short getValueAsUnsignedByte() throws TlvConvertException {
        try {
            return ByteArrayUtil.toUnsignedByte((byte[])this.value);
        }
        catch (IllegalArgumentException e) {
            throw new TlvConvertException("unsigned byte", e.getMessage());
        }
    }

    public short getValueAsShort() throws TlvConvertException {
        try {
            return ByteArrayUtil.toShort((byte[])this.value);
        }
        catch (IllegalArgumentException e) {
            throw new TlvConvertException("short", e.getMessage());
        }
    }

    public int getValueAsUnsignedShort() throws TlvConvertException {
        try {
            return ByteArrayUtil.toUnsignedShort((byte[])this.value);
        }
        catch (IllegalArgumentException e) {
            throw new TlvConvertException("unsigned short", e.getMessage());
        }
    }

    public int getValueAsInt() throws TlvConvertException {
        try {
            return ByteArrayUtil.toInt((byte[])this.value);
        }
        catch (IllegalArgumentException e) {
            throw new TlvConvertException("int", e.getMessage());
        }
    }

    public long getValueAsUnsignedInt() throws TlvConvertException {
        try {
            return ByteArrayUtil.toUnsignedInt((byte[])this.value);
        }
        catch (IllegalArgumentException e) {
            throw new TlvConvertException("unsigned int", e.getMessage());
        }
    }

    public long getValueAsLong() throws TlvConvertException {
        try {
            return ByteArrayUtil.toLong((byte[])this.value);
        }
        catch (IllegalArgumentException e) {
            throw new TlvConvertException("long", e.getMessage());
        }
    }
}

