/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.vbucket;

import com.couchbase.client.http.HttpUtil;
import com.couchbase.client.vbucket.BucketMonitor;
import com.couchbase.client.vbucket.ConfigurationException;
import com.couchbase.client.vbucket.ConfigurationProvider;
import com.couchbase.client.vbucket.Reconfigurable;
import com.couchbase.client.vbucket.ReconfigurableObserver;
import com.couchbase.client.vbucket.config.Bucket;
import com.couchbase.client.vbucket.config.Config;
import com.couchbase.client.vbucket.config.ConfigType;
import com.couchbase.client.vbucket.config.ConfigurationParser;
import com.couchbase.client.vbucket.config.ConfigurationParserJSON;
import com.couchbase.client.vbucket.config.Pool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.compat.SpyObject;

public class ConfigurationProviderHTTP
extends SpyObject
implements ConfigurationProvider {
    private static final String DEFAULT_POOL_NAME = "default";
    private static final String ANONYMOUS_AUTH_BUCKET = "default";
    public static final String CLIENT_SPEC_VER = "1.0";
    private volatile List<URI> baseList;
    private final String restUsr;
    private final String restPwd;
    private volatile URI loadedBaseUri;
    private final Map<String, Bucket> buckets = new ConcurrentHashMap<String, Bucket>();
    private final ConfigurationParser configurationParser = new ConfigurationParserJSON();
    private final Map<String, BucketMonitor> monitors = new HashMap<String, BucketMonitor>();
    private volatile String reSubBucket;
    private volatile Reconfigurable reSubRec;

    public ConfigurationProviderHTTP(List<URI> baseList) {
        this(baseList, null, null);
    }

    public ConfigurationProviderHTTP(List<URI> baseList, String restUsr, String restPwd) {
        this.baseList = baseList;
        this.restUsr = restUsr;
        this.restPwd = restPwd;
    }

    @Override
    public synchronized Reconfigurable getReconfigurable() {
        return this.reSubRec;
    }

    @Override
    public synchronized String getBucket() {
        return this.reSubBucket;
    }

    @Override
    public Bucket getBucketConfiguration(String bucketname) {
        if (bucketname == null || bucketname.isEmpty()) {
            throw new IllegalArgumentException("Bucket name can not be blank.");
        }
        Bucket bucket = this.buckets.get(bucketname);
        if (bucket == null) {
            boolean warmedUp = false;
            int maxBackoffRetries = 5;
            int retryCount = 1;
            while (!warmedUp) {
                this.readPools(bucketname);
                Config config = this.buckets.get(bucketname).getConfig();
                if (config.getConfigType().equals((Object)ConfigType.MEMCACHE)) {
                    warmedUp = true;
                    continue;
                }
                if (config.getVbucketsCount() == 0) {
                    if (retryCount > maxBackoffRetries) {
                        throw new ConfigurationException("Cluster is not in a warmed up state after " + maxBackoffRetries + " exponential retries.");
                    }
                    int backoffSeconds = new Double((double)retryCount * Math.pow(2.0, retryCount++)).intValue();
                    this.getLogger().info((Object)("Cluster is currently warming up, waiting " + backoffSeconds + " seconds for vBuckets to show up."));
                    try {
                        Thread.sleep(backoffSeconds * 1000);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        throw new ConfigurationException("Cluster is not in a warmed up state.");
                    }
                }
                warmedUp = true;
            }
        }
        return this.buckets.get(bucketname);
    }

    @Override
    public void updateBucket(String bucketname, Bucket newBucket) {
        this.buckets.put(bucketname, newBucket);
    }

    private void readPools(String bucketToFind) {
        for (URI baseUri : this.baseList) {
            try {
                URLConnection baseConnection = this.urlConnBuilder(null, baseUri);
                String base = this.readToString(baseConnection);
                if ("".equals(base)) {
                    this.getLogger().warn((Object)("Provided URI " + baseUri + " has an empty" + " response... skipping"));
                    continue;
                }
                Map<String, Pool> pools = this.configurationParser.parsePools(base);
                if (!pools.containsKey("default")) {
                    this.getLogger().warn((Object)("Provided URI " + baseUri + " has no default pool" + "... skipping"));
                    continue;
                }
                for (Pool pool : pools.values()) {
                    URLConnection poolConnection = this.urlConnBuilder(baseUri, pool.getUri());
                    String poolString = this.readToString(poolConnection);
                    this.configurationParser.parsePool(pool, poolString);
                    URLConnection poolBucketsConnection = this.urlConnBuilder(baseUri, pool.getBucketsUri());
                    String sBuckets = this.readToString(poolBucketsConnection);
                    Map<String, Bucket> bucketsForPool = this.configurationParser.parseBuckets(sBuckets);
                    pool.replaceBuckets(bucketsForPool);
                }
                boolean bucketFound = false;
                for (Pool pool : pools.values()) {
                    if (!pool.hasBucket(bucketToFind)) continue;
                    bucketFound = true;
                    break;
                }
                if (!bucketFound) continue;
                for (Pool pool : pools.values()) {
                    for (Map.Entry<String, Bucket> bucketEntry : pool.getROBuckets().entrySet()) {
                        this.buckets.put(bucketEntry.getKey(), bucketEntry.getValue());
                    }
                }
                if (this.buckets.get(bucketToFind) == null) {
                    this.getLogger().warn((Object)"Bucket found, but has no bucket configuration attached...skipping");
                    continue;
                }
                this.loadedBaseUri = baseUri;
                return;
            }
            catch (ParseException e) {
                this.getLogger().warn((Object)("Provided URI " + baseUri + " has an unparsable response...skipping"), (Throwable)e);
            }
            catch (IOException e) {
                this.getLogger().warn((Object)("Connection problems with URI " + baseUri + " ...skipping"), (Throwable)e);
            }
        }
        throw new ConfigurationException("Configuration for bucket \"" + bucketToFind + "\" was not found in server list (" + this.baseList + ").");
    }

    public List<InetSocketAddress> getServerList(String bucketname) {
        Bucket bucket = this.getBucketConfiguration(bucketname);
        List<String> servers = bucket.getConfig().getServers();
        StringBuilder serversString = new StringBuilder();
        for (String server : servers) {
            serversString.append(server).append(' ');
        }
        return AddrUtil.getAddresses((String)serversString.toString());
    }

    @Override
    public synchronized void finishResubscribe() {
        this.monitors.clear();
        this.subscribe(this.reSubBucket, this.reSubRec);
    }

    @Override
    public synchronized void markForResubscribe(String bucketName, Reconfigurable rec) {
        this.getLogger().debug((Object)("Marking bucket " + bucketName + " for resubscribe with reconfigurable " + rec));
        this.reSubBucket = bucketName;
        this.reSubRec = rec;
    }

    @Override
    public synchronized void subscribe(String bucketName, Reconfigurable rec) {
        if (null == bucketName || null != this.reSubBucket && !bucketName.equals(this.reSubBucket)) {
            throw new IllegalArgumentException("Bucket name cannot be null and must never be re-set to a new object. Bucket: " + bucketName + ", reSubBucket: " + this.reSubBucket);
        }
        if (null == rec || null != this.reSubRec && rec != this.reSubRec) {
            throw new IllegalArgumentException("Reconfigurable cannot be null and must never be re-set to a new object");
        }
        this.reSubBucket = bucketName;
        this.reSubRec = rec;
        this.getLogger().debug((Object)("Subscribing an object for reconfiguration updates " + rec.getClass().getName()));
        Bucket bucket = this.getBucketConfiguration(bucketName);
        if (bucket == null) {
            throw new ConfigurationException("Could not get bucket configuration for: " + bucketName);
        }
        ReconfigurableObserver obs = new ReconfigurableObserver(rec);
        BucketMonitor monitor = this.monitors.get(bucketName);
        if (monitor == null) {
            URI streamingURI = bucket.getStreamingURI();
            monitor = new BucketMonitor(this.loadedBaseUri.resolve(streamingURI), this.restUsr, this.restPwd, this.configurationParser, this);
            this.monitors.put(bucketName, monitor);
            monitor.addObserver(obs);
            monitor.startMonitor();
        } else {
            monitor.addObserver(obs);
        }
    }

    @Override
    public void unsubscribe(String vbucketName, Reconfigurable rec) {
        BucketMonitor monitor = this.monitors.get(vbucketName);
        if (monitor != null) {
            monitor.deleteObserver(new ReconfigurableObserver(rec));
        }
    }

    public Config getLatestConfig(String bucketname) {
        Bucket bucket = this.getBucketConfiguration(bucketname);
        return bucket.getConfig();
    }

    @Override
    public String getAnonymousAuthBucket() {
        return "default";
    }

    @Override
    public void shutdown() {
        for (BucketMonitor monitor : this.monitors.values()) {
            monitor.shutdown();
        }
    }

    private URLConnection urlConnBuilder(URI base, URI resource) throws IOException {
        if (!resource.isAbsolute() && base != null) {
            resource = base.resolve(resource);
        }
        URL specURL = resource.toURL();
        URLConnection connection = specURL.openConnection();
        connection.setConnectTimeout(500);
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("user-agent", "Couchbase Java Client");
        connection.setRequestProperty("X-memcachekv-Store-Client-Specification-Version", CLIENT_SPEC_VER);
        if (this.restUsr != null) {
            try {
                connection.setRequestProperty("Authorization", HttpUtil.buildAuthHeader(this.restUsr, this.restPwd));
            }
            catch (UnsupportedEncodingException ex) {
                throw new IOException("Could not encode specified credentials for HTTP request.", ex);
            }
        }
        return connection;
    }

    private String readToString(URLConnection connection) throws IOException {
        BufferedReader reader = null;
        this.getLogger().debug((Object)("Attempting to read configuration from URI: " + connection.getURL()));
        try {
            String str;
            connection.setConnectTimeout(500);
            connection.setReadTimeout(5000);
            InputStream inStream = connection.getInputStream();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                if (httpConnection.getResponseCode() == 403) {
                    throw new IOException("Service does not accept the authentication credentials: " + httpConnection.getResponseCode() + httpConnection.getResponseMessage());
                }
                if (httpConnection.getResponseCode() >= 400) {
                    throw new IOException("Service responded with a failure code: " + httpConnection.getResponseCode() + httpConnection.getResponseMessage());
                }
            } else {
                throw new IOException("Unexpected URI type encountered");
            }
            reader = new BufferedReader(new InputStreamReader(inStream));
            StringBuilder buffer = new StringBuilder();
            while ((str = reader.readLine()) != null) {
                buffer.append(str);
            }
            String string = buffer.toString();
            return string;
        }
        catch (SocketTimeoutException ex) {
            String msg = "Timed out while reading configuration over HTTP";
            this.getLogger().warn((Object)msg, (Throwable)ex);
            throw new IOException(msg, ex);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public synchronized String toString() {
        String result = "";
        result = result + "bucket: " + this.reSubBucket;
        result = result + "reconf:" + this.reSubRec;
        result = result + "baseList:" + this.baseList;
        return result;
    }

    @Override
    public void updateBaseListFromConfig(List<URI> newList) {
        this.baseList = newList;
    }

    @Override
    public void updateBucket(String config) {
        try {
            this.updateBucket(this.getBucket(), this.configurationParser.parseBucket(config));
        }
        catch (Exception ex) {
            this.getLogger().warn((Object)"Got new config to update, but could not decode it. Staying with old one.", (Throwable)ex);
            this.getLogger().debug((Object)("Problematic config is:" + config));
        }
    }

    public void clearBuckets() {
        this.buckets.clear();
    }
}

