/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.vbucket;

import com.couchbase.client.vbucket.Reconfigurable;
import com.couchbase.client.vbucket.config.Bucket;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;

public class ReconfigurableObserver
implements Observer {
    private final Reconfigurable rec;
    private static final Logger LOGGER = Logger.getLogger(ReconfigurableObserver.class.getName());

    public ReconfigurableObserver(Reconfigurable rec) {
        this.rec = rec;
    }

    @Override
    public void update(Observable o, Object arg) {
        LOGGER.finest("Received an update, notifying reconfigurables about a " + arg.getClass().getName() + arg.toString());
        LOGGER.finest("It says it is " + ((Bucket)arg).getName() + " and it's talking to " + ((Bucket)arg).getStreamingURI());
        this.rec.reconfigure((Bucket)arg);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReconfigurableObserver that = (ReconfigurableObserver)o;
        return this.rec.equals(that.rec);
    }

    public int hashCode() {
        return this.rec.hashCode();
    }
}

