/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.fldr;

import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.BaseFilter;
import dm.jdbc.filter.FilterChain;
import dm.jdbc.filter.fldr.Callback;
import dm.jdbc.filter.fldr.FldrManager;
import dm.jdbc.filter.fldr.FldrResultSet;
import dm.jdbc.internal.conf.DmProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;

public class FldrFilter
extends BaseFilter {
    private FldrFilter() {
    }

    public static FldrFilter getInstance() {
        return FldrFilterThreadHolder.instance;
    }

    @Override
    public Connection Driver_connect(FilterChain filterChain, DmDriver driver, DmProperties props) throws SQLException {
        Connection connection = super.Driver_connect(filterChain, driver, props);
        FldrManager.createConnection((DmdbConnection)connection);
        return connection;
    }

    @Override
    public void Connection_close(FilterChain chain, DmdbConnection connection) throws SQLException {
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    try {
                        if (siteObject != null) {
                            siteObject.do_close();
                        }
                    }
                    catch (Exception exception) {}
                }
            });
            connection.fldrInfo.clearFldr();
        }
        super.Connection_close(chain, connection);
    }

    @Override
    public void Connection_commit(FilterChain chain, DmdbConnection connection) throws SQLException {
        super.Connection_commit(chain, connection);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_commit();
                }
            });
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain chain, DmdbConnection connection, String sql) throws SQLException {
        PreparedStatement pstmt = super.Connection_prepareStatement(chain, connection, sql);
        FldrManager.fldrPrepareSql(connection, sql, pstmt);
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain chain, DmdbConnection connection, String sql, String[] columnNames) throws SQLException {
        int autoGeneratedKeys = 0;
        if (columnNames != null && columnNames.length > 0) {
            autoGeneratedKeys = 1;
        }
        return this.Connection_prepareStatement(chain, connection, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain chain, DmdbConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement pstmt = this.Connection_prepareStatement(chain, connection, sql);
        ((DmdbPreparedStatement)pstmt).autoGeneratedKeys = autoGeneratedKeys;
        if (((DmdbPreparedStatement)pstmt).fldrInfo.fldrStmtMap != null && ((DmdbPreparedStatement)pstmt).fldrInfo.getFldrStmtSize() > 0) {
            for (DmdbStatement temp : ((DmdbPreparedStatement)pstmt).fldrInfo.fldrStmtMap.values()) {
                ((DmdbPreparedStatement)temp).autoGeneratedKeys = autoGeneratedKeys;
            }
        }
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain chain, DmdbConnection connection, String sql, int[] columnIndexes) throws SQLException {
        int autoGeneratedKeys = 0;
        if (columnIndexes != null && columnIndexes.length > 0) {
            autoGeneratedKeys = 1;
        }
        return this.Connection_prepareStatement(chain, connection, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain chain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement pstmt = super.Connection_prepareStatement(chain, connection, sql, resultSetType, resultSetConcurrency);
        FldrManager.fldrPrepareSql(connection, sql, pstmt);
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(FilterChain chain, DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement pstmt = super.Connection_prepareStatement(chain, connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        FldrManager.fldrPrepareSql(connection, sql, pstmt);
        return pstmt;
    }

    @Override
    public void Connection_releaseSavepoint(FilterChain chain, DmdbConnection connection, final Savepoint savepoint) throws SQLException {
        super.Connection_releaseSavepoint(chain, connection, savepoint);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_releaseSavepoint(savepoint);
                }
            });
        }
    }

    @Override
    public void Connection_rollback(FilterChain chain, DmdbConnection connection) throws SQLException {
        super.Connection_rollback(chain, connection);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_rollback();
                }
            });
        }
    }

    @Override
    public void Connection_rollback(FilterChain chain, DmdbConnection connection, final Savepoint savepoint) throws SQLException {
        super.Connection_rollback(chain, connection, savepoint);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_rollback(savepoint);
                }
            });
        }
    }

    @Override
    public void Connection_setAutoCommit(FilterChain chain, DmdbConnection connection, final boolean autoCommit) throws SQLException {
        super.Connection_setAutoCommit(chain, connection, autoCommit);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setAutoCommit(autoCommit);
                }
            });
        }
    }

    @Override
    public void Connection_setClientInfo(FilterChain chain, DmdbConnection connection, final Properties properties) throws SQLClientInfoException {
        super.Connection_setClientInfo(chain, connection, properties);
        if (connection.fldrInfo.fldrConnMap != null) {
            try {
                FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                    @Override
                    void run(DmdbConnection siteObject) throws SQLException {
                        siteObject.do_setClientInfo(properties);
                    }
                });
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void Connection_setClientInfo(FilterChain chain, DmdbConnection connection, final String name, final String value) throws SQLClientInfoException {
        super.Connection_setClientInfo(chain, connection, name, value);
        if (connection.fldrInfo.fldrConnMap != null) {
            try {
                FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                    @Override
                    void run(DmdbConnection siteObject) throws SQLException {
                        siteObject.do_setClientInfo(name, value);
                    }
                });
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void Connection_setHoldability(FilterChain chain, DmdbConnection connection, final int holdability) throws SQLException {
        super.Connection_setHoldability(chain, connection, holdability);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setHoldability(holdability);
                }
            });
        }
    }

    @Override
    public void Connection_setReadOnly(FilterChain chain, DmdbConnection connection, final boolean readOnly) throws SQLException {
        super.Connection_setReadOnly(chain, connection, readOnly);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setReadOnly(readOnly);
                }
            });
        }
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain chain, DmdbConnection connection) throws SQLException {
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setSavepoint();
                }
            });
        }
        return chain.Connection_setSavepoint(connection);
    }

    @Override
    public Savepoint Connection_setSavepoint(FilterChain chain, DmdbConnection connection, final String name) throws SQLException {
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setSavepoint(name);
                }
            });
        }
        return chain.Connection_setSavepoint(connection, name);
    }

    @Override
    public void Connection_setSchema(FilterChain chain, DmdbConnection connection, final String schema) throws SQLException {
        super.Connection_setSchema(chain, connection, schema);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setSchema(schema);
                }
            });
        }
    }

    @Override
    public void Connection_setTransactionIsolation(FilterChain chain, DmdbConnection connection, final int level) throws SQLException {
        super.Connection_setTransactionIsolation(chain, connection, level);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setTransactionIsolation(level);
                }
            });
        }
    }

    @Override
    public void Connection_setTypeMap(FilterChain chain, DmdbConnection connection, final Map<String, Class<?>> map) throws SQLException {
        super.Connection_setTypeMap(chain, connection, map);
        if (connection.fldrInfo.fldrConnMap != null) {
            FldrManager.doTaskOnEverySite(connection.fldrInfo.fldrExecutor, connection.fldrInfo.fldrConnMap.values(), connection.fldrInfo.getFldrConnSize(), new Callback<DmdbConnection>(){

                @Override
                void run(DmdbConnection siteObject) throws SQLException {
                    siteObject.do_setTypeMap(map);
                }
            });
        }
    }

    @Override
    public Statement Connection_createStatement(FilterChain chain, DmdbConnection connection) throws SQLException {
        Statement stmt = super.Connection_createStatement(chain, connection);
        FldrManager.createStatement((DmdbStatement)stmt, stmt.getResultSetType(), stmt.getResultSetConcurrency(), stmt.getResultSetHoldability());
        return stmt;
    }

    @Override
    public Statement Connection_createStatement(FilterChain chain, DmdbConnection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt = super.Connection_createStatement(chain, connection, resultSetType, resultSetConcurrency);
        FldrManager.createStatement((DmdbStatement)stmt, stmt.getResultSetType(), stmt.getResultSetConcurrency(), stmt.getResultSetHoldability());
        return stmt;
    }

    @Override
    public Statement Connection_createStatement(FilterChain chain, DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stmt = super.Connection_createStatement(chain, connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        FldrManager.createStatement((DmdbStatement)stmt, stmt.getResultSetType(), stmt.getResultSetConcurrency(), stmt.getResultSetHoldability());
        return stmt;
    }

    @Override
    public ResultSet Statement_executeQuery(FilterChain chain, DmdbStatement statement, final String sql) throws SQLException {
        if (FldrManager.canFldrForSelect(statement)) {
            super.Statement_executeQuery(chain, statement, sql);
            final FldrResultSet fldrRs = new FldrResultSet(statement);
            ExecutorService executor = statement.connection.fldrInfo.fldrExecutor;
            for (final DmdbStatement siteObject : statement.fldrInfo.fldrStmtMap.values()) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DmdbResultSet rs = siteObject.do_executeQuery(sql);
                            fldrRs.registRs(rs);
                            fldrRs.putRs(rs);
                        }
                        catch (SQLException e2) {
                            fldrRs.putRs(e2);
                        }
                    }
                });
            }
            fldrRs.init();
            return fldrRs;
        }
        return super.Statement_executeQuery(chain, statement, sql);
    }

    @Override
    public void Statement_close(FilterChain chain, DmdbStatement statement) throws SQLException {
        if (statement.fldrInfo.fldrStmtMap != null) {
            FldrManager.doTaskOnEverySite(statement.connection.fldrInfo.fldrExecutor, statement.fldrInfo.fldrStmtMap.values(), statement.fldrInfo.getFldrStmtSize(), new Callback<DmdbStatement>(){

                @Override
                void run(DmdbStatement siteObject) throws SQLException {
                    try {
                        if (siteObject != null) {
                            siteObject.do_close();
                        }
                    }
                    catch (Exception exception) {}
                }
            });
            statement.fldrInfo.clearFldr();
        }
        super.Statement_close(chain, statement);
    }

    @Override
    public void PreparedStatement_addBatch(FilterChain chain, DmdbPreparedStatement preparedStatement) throws SQLException {
        super.PreparedStatement_addBatch(chain, preparedStatement);
        FldrManager.addBatch(preparedStatement);
    }

    @Override
    public int[] PreparedStatement_executeBatch(FilterChain chain, DmdbPreparedStatement preparedStatement) throws SQLException {
        if (chain.fpos < chain.filters.length) {
            return chain.filters[chain.fpos++].PreparedStatement_executeBatch(chain, preparedStatement);
        }
        return FldrManager.executeBatch(preparedStatement);
    }

    @Override
    public void PreparedStatement_clearParameters(FilterChain chain, DmdbPreparedStatement pstmt) throws SQLException {
        super.PreparedStatement_clearParameters(chain, pstmt);
        if (pstmt.fldrInfo.fldrStmtMap != null) {
            FldrManager.doTaskOnEverySite(pstmt.connection.fldrInfo.fldrExecutor, pstmt.fldrInfo.fldrStmtMap.values(), pstmt.fldrInfo.getFldrStmtSize(), new Callback<DmdbStatement>(){

                @Override
                void run(DmdbStatement siteObject) throws SQLException {
                    ((DmdbPreparedStatement)siteObject).do_clearParameters();
                }
            });
        }
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(FilterChain chain, DmdbPreparedStatement pstmt) throws SQLException {
        if (FldrManager.canFldrForSelect(pstmt)) {
            super.PreparedStatement_executeQuery(chain, pstmt);
            final FldrResultSet fldrRs = new FldrResultSet(pstmt);
            ExecutorService executor = pstmt.connection.fldrInfo.fldrExecutor;
            final Object[] curRowObjects = pstmt.curRowDatas;
            for (final DmdbStatement siteObject : pstmt.fldrInfo.fldrStmtMap.values()) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (curRowObjects != null) {
                                int i2 = 0;
                                while (i2 < curRowObjects.length) {
                                    ((DmdbPreparedStatement)siteObject).do_setObject(i2 + 1, curRowObjects[i2]);
                                    ++i2;
                                }
                            }
                            DmdbResultSet rs = ((DmdbPreparedStatement)siteObject).do_executeQuery();
                            fldrRs.registRs(rs);
                            fldrRs.putRs(rs);
                        }
                        catch (SQLException e2) {
                            fldrRs.putRs(e2);
                        }
                    }
                });
            }
            fldrRs.init();
            return fldrRs;
        }
        return super.PreparedStatement_executeQuery(chain, pstmt);
    }

    /* synthetic */ FldrFilter(FldrFilter fldrFilter) {
        this();
    }

    private static class FldrFilterThreadHolder {
        private static final FldrFilter instance = new FldrFilter(null);

        private FldrFilterThreadHolder() {
        }
    }
}

