/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util.buffer;

import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.buffer.BufferNode;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayNode
extends BufferNode<byte[]> {
    ByteArrayNode(int capacity) {
        super(new byte[capacity], capacity);
    }

    ByteArrayNode(byte[] bytes, int offset, int len) {
        super(bytes, bytes.length);
        this.read = offset;
        this.write = offset + len;
    }

    @Override
    public void clear(int offset) {
        this.write = offset;
        if (this.read > offset) {
            this.read = offset;
        }
    }

    @Override
    public void rewind(int offset) {
        this.read = offset;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int length(boolean forWrite) {
        return forWrite ? this.write : this.read;
    }

    @Override
    public int offset(boolean forWrite) {
        return forWrite ? this.write : this.read;
    }

    @Override
    public int available(boolean forWrite) {
        return forWrite ? this.capacity - this.write : this.write - this.read;
    }

    @Override
    public int skip(int length, boolean forWrite, boolean forward) {
        int available;
        int n2 = available = forward ? this.available(forWrite) : this.length(forWrite);
        if (length > available) {
            length = available;
        }
        if (forward) {
            if (forWrite) {
                int i2 = 0;
                while (i2 < length) {
                    ((byte[])this.buffer)[this.write++] = 0;
                    ++i2;
                }
            } else {
                this.read += length;
            }
        } else if (forWrite) {
            this.write -= length;
        } else {
            this.read -= length;
        }
        return length;
    }

    @Override
    public int load(Object object, int len, boolean fully) throws IOException {
        int available;
        int n2 = available = fully ? this.capacity : this.available(true);
        if (len > available) {
            len = available;
        }
        int llen = 0;
        while (llen < len) {
            int ret = ((InputStream)object).read((byte[])this.buffer, this.write, len - llen);
            if (ret < 0) {
                throw new EOFException();
            }
            llen += ret;
            this.write += ret;
        }
        return llen;
    }

    @Override
    public int flush(Object object, boolean fully) throws IOException {
        int flen = 0;
        if (fully) {
            flen = this.capacity;
            ((OutputStream)object).write((byte[])this.buffer, 0, this.capacity);
        } else {
            flen = this.write - this.read;
            ((OutputStream)object).write((byte[])this.buffer, this.read, flen);
        }
        this.read += flen;
        return flen;
    }

    @Override
    public int writeByte(byte b2) {
        this.write += ByteUtil.setByte((byte[])this.buffer, this.write, b2);
        return 1;
    }

    @Override
    public int writeShort(short s2) {
        this.write += ByteUtil.setShort((byte[])this.buffer, this.write, s2);
        return 2;
    }

    @Override
    public int writeInt(int i2) {
        this.write += ByteUtil.setInt((byte[])this.buffer, this.write, i2);
        return 4;
    }

    @Override
    public int writeLong(long l2) {
        this.write += ByteUtil.setLong((byte[])this.buffer, this.write, l2);
        return 8;
    }

    @Override
    public int writeFloat(float f2) {
        this.write += ByteUtil.setFloat((byte[])this.buffer, this.write, f2);
        return 4;
    }

    @Override
    public int writeDouble(double d2) {
        this.write += ByteUtil.setDouble((byte[])this.buffer, this.write, d2);
        return 8;
    }

    @Override
    public int writeUB1(int i2) {
        this.write += ByteUtil.setUB1((byte[])this.buffer, this.write, i2);
        return 1;
    }

    @Override
    public int writeUB2(int i2) {
        this.write += ByteUtil.setUB2((byte[])this.buffer, this.write, i2);
        return 2;
    }

    @Override
    public int writeUB4(long l2) {
        this.write += ByteUtil.setUB4((byte[])this.buffer, this.write, l2);
        return 4;
    }

    @Override
    public int writeBytes(byte[] srcBytes, int srcOffset, int len) {
        this.write += ByteUtil.setBytes((byte[])this.buffer, this.write, srcBytes, srcOffset, len);
        return len;
    }

    @Override
    public byte readByte() {
        byte bv = ByteUtil.getByte((byte[])this.buffer, this.read);
        ++this.read;
        return bv;
    }

    @Override
    public short readShort() {
        short sv = ByteUtil.getShort((byte[])this.buffer, this.read);
        this.read += 2;
        return sv;
    }

    @Override
    public int readInt() {
        int iv = ByteUtil.getInt((byte[])this.buffer, this.read);
        this.read += 4;
        return iv;
    }

    @Override
    public long readLong() {
        long lv = ByteUtil.getLong((byte[])this.buffer, this.read);
        this.read += 8;
        return lv;
    }

    @Override
    public float readFloat() {
        float fv = ByteUtil.getFloat((byte[])this.buffer, this.read);
        this.read += 4;
        return fv;
    }

    @Override
    public double readDouble() {
        double dv = ByteUtil.getDouble((byte[])this.buffer, this.read);
        this.read += 8;
        return dv;
    }

    @Override
    public int readUB1() {
        int iv = ByteUtil.getUB1((byte[])this.buffer, this.read);
        ++this.read;
        return iv;
    }

    @Override
    public int readUB2() {
        int iv = ByteUtil.getUB2((byte[])this.buffer, this.read);
        this.read += 2;
        return iv;
    }

    @Override
    public long readUB4() {
        long lv = ByteUtil.getUB4((byte[])this.buffer, this.read);
        this.read += 4;
        return lv;
    }

    @Override
    public int readBytes(byte[] objBytes, int objOffset, int len) {
        this.read += ByteUtil.getBytes((byte[])this.buffer, this.read, objBytes, objOffset, len);
        return len;
    }

    @Override
    public int setByte(int offset, byte b2) {
        return ByteUtil.setByte((byte[])this.buffer, offset, b2);
    }

    @Override
    public int setShort(int offset, short s2) {
        return ByteUtil.setShort((byte[])this.buffer, offset, s2);
    }

    @Override
    public int setInt(int offset, int i2) {
        return ByteUtil.setInt((byte[])this.buffer, offset, i2);
    }

    @Override
    public int setLong(int offset, long l2) {
        return ByteUtil.setLong((byte[])this.buffer, offset, l2);
    }

    @Override
    public int setFloat(int offset, float f2) {
        return ByteUtil.setFloat((byte[])this.buffer, offset, f2);
    }

    @Override
    public int setDouble(int offset, double d2) {
        return ByteUtil.setDouble((byte[])this.buffer, offset, d2);
    }

    @Override
    public int setUB1(int offset, int i2) {
        return ByteUtil.setUB1((byte[])this.buffer, offset, i2);
    }

    @Override
    public int setUB2(int offset, int i2) {
        return ByteUtil.setUB2((byte[])this.buffer, offset, i2);
    }

    @Override
    public int setUB4(int offset, long l2) {
        return ByteUtil.setUB4((byte[])this.buffer, offset, l2);
    }

    @Override
    public int setBytes(int offset, byte[] srcBytes, int srcOffset, int len) {
        return ByteUtil.setBytes((byte[])this.buffer, offset, srcBytes, srcOffset, len);
    }

    @Override
    public byte getByte(int offset) {
        return ByteUtil.getByte((byte[])this.buffer, offset);
    }

    @Override
    public short getShort(int offset) {
        return ByteUtil.getShort((byte[])this.buffer, offset);
    }

    @Override
    public int getInt(int offset) {
        return ByteUtil.getInt((byte[])this.buffer, offset);
    }

    @Override
    public long getLong(int offset) {
        return ByteUtil.getLong((byte[])this.buffer, offset);
    }

    @Override
    public float getFloat(int offset) {
        return ByteUtil.getFloat((byte[])this.buffer, offset);
    }

    @Override
    public double getDouble(int offset) {
        return ByteUtil.getDouble((byte[])this.buffer, offset);
    }

    @Override
    public int getUB1(int offset) {
        return ByteUtil.getUB1((byte[])this.buffer, offset);
    }

    @Override
    public int getUB2(int offset) {
        return ByteUtil.getUB2((byte[])this.buffer, offset);
    }

    @Override
    public long getUB4(int offset) {
        return ByteUtil.getUB4((byte[])this.buffer, offset);
    }

    @Override
    public int getBytes(int offset, byte[] objBytes, int objOffset, int len) {
        return ByteUtil.getBytes((byte[])this.buffer, offset, objBytes, objOffset, len);
    }
}

