/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverInternalError;
import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableMap;

abstract class CBUtil {
    private CBUtil() {
    }

    private static String readString(ByteBuf cb, int length) {
        try {
            String str2 = cb.toString(cb.readerIndex(), length, CharsetUtil.UTF_8);
            cb.readerIndex(cb.readerIndex() + length);
            return str2;
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof CharacterCodingException) {
                throw new DriverInternalError("Cannot decode string as UTF8");
            }
            throw e;
        }
    }

    public static String readString(ByteBuf cb) {
        try {
            int length = cb.readUnsignedShort();
            return CBUtil.readString(cb, length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DriverInternalError("Not enough bytes to read an UTF8 serialized string preceded by it's 2 bytes length");
        }
    }

    public static void writeString(String str2, ByteBuf cb) {
        byte[] bytes = str2.getBytes(CharsetUtil.UTF_8);
        cb.writeShort(bytes.length);
        cb.writeBytes(bytes);
    }

    public static int sizeOfString(String str2) {
        return 2 + CBUtil.encodedUTF8Length(str2);
    }

    private static int encodedUTF8Length(String st) {
        int strlen = st.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = st.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    public static String readLongString(ByteBuf cb) {
        try {
            int length = cb.readInt();
            return CBUtil.readString(cb, length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DriverInternalError("Not enough bytes to read an UTF8 serialized string preceded by it's 4 bytes length");
        }
    }

    public static void writeLongString(String str2, ByteBuf cb) {
        byte[] bytes = str2.getBytes(CharsetUtil.UTF_8);
        cb.writeInt(bytes.length);
        cb.writeBytes(bytes);
    }

    public static int sizeOfLongString(String str2) {
        return 4 + str2.getBytes(CharsetUtil.UTF_8).length;
    }

    public static byte[] readBytes(ByteBuf cb) {
        try {
            int length = cb.readUnsignedShort();
            byte[] bytes = new byte[length];
            cb.readBytes(bytes);
            return bytes;
        }
        catch (IndexOutOfBoundsException e) {
            throw new DriverInternalError("Not enough bytes to read a byte array preceded by it's 2 bytes length");
        }
    }

    public static void writeBytes(byte[] bytes, ByteBuf cb) {
        cb.writeShort(bytes.length);
        cb.writeBytes(bytes);
    }

    public static void writeBytes(ByteBuffer bytes, ByteBuf cb) {
        cb.writeShort(bytes.remaining());
        cb.writeBytes(bytes.duplicate());
    }

    public static int sizeOfBytes(byte[] bytes) {
        return 2 + bytes.length;
    }

    public static int sizeOfBytes(ByteBuffer bytes) {
        return 2 + bytes.remaining();
    }

    public static Map<String, ByteBuffer> readBytesMap(ByteBuf cb) {
        int length = cb.readUnsignedShort();
        ImmutableMap.Builder<String, ByteBuffer> builder = ImmutableMap.builder();
        for (int i = 0; i < length; ++i) {
            String key = CBUtil.readString(cb);
            ByteBuffer value2 = CBUtil.readValue(cb);
            if (value2 == null) {
                value2 = Statement.NULL_PAYLOAD_VALUE;
            }
            builder.put(key, value2);
        }
        return builder.build();
    }

    public static void writeBytesMap(Map<String, ByteBuffer> m, ByteBuf cb) {
        cb.writeShort(m.size());
        for (Map.Entry<String, ByteBuffer> entry : m.entrySet()) {
            CBUtil.writeString(entry.getKey(), cb);
            ByteBuffer value2 = entry.getValue();
            if (value2 == Statement.NULL_PAYLOAD_VALUE) {
                value2 = null;
            }
            CBUtil.writeValue(value2, cb);
        }
    }

    public static int sizeOfBytesMap(Map<String, ByteBuffer> m) {
        int size = 2;
        for (Map.Entry<String, ByteBuffer> entry : m.entrySet()) {
            size += CBUtil.sizeOfString(entry.getKey());
            size += CBUtil.sizeOfBytes(entry.getValue());
        }
        return size;
    }

    public static ConsistencyLevel readConsistencyLevel(ByteBuf cb) {
        return ConsistencyLevel.fromCode(cb.readUnsignedShort());
    }

    public static void writeConsistencyLevel(ConsistencyLevel consistency, ByteBuf cb) {
        cb.writeShort(consistency.code);
    }

    public static int sizeOfConsistencyLevel(ConsistencyLevel consistency) {
        return 2;
    }

    public static <T extends Enum<T>> T readEnumValue(Class<T> enumType, ByteBuf cb) {
        String value2 = CBUtil.readString(cb);
        try {
            return Enum.valueOf(enumType, value2.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new DriverInternalError(String.format("Invalid value '%s' for %s", value2, enumType.getSimpleName()));
        }
    }

    public static <T extends Enum<T>> void writeEnumValue(T enumValue, ByteBuf cb) {
        CBUtil.writeString(enumValue.toString(), cb);
    }

    public static <T extends Enum<T>> int sizeOfEnumValue(T enumValue) {
        return CBUtil.sizeOfString(enumValue.toString());
    }

    public static UUID readUUID(ByteBuf cb) {
        long msb = cb.readLong();
        long lsb = cb.readLong();
        return new UUID(msb, lsb);
    }

    public static void writeUUID(UUID uuid2, ByteBuf cb) {
        cb.writeLong(uuid2.getMostSignificantBits());
        cb.writeLong(uuid2.getLeastSignificantBits());
    }

    public static int sizeOfUUID(UUID uuid2) {
        return 16;
    }

    public static List<String> readStringList(ByteBuf cb) {
        int length = cb.readUnsignedShort();
        ArrayList<String> l = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            l.add(CBUtil.readString(cb));
        }
        return l;
    }

    public static void writeStringList(List<String> l, ByteBuf cb) {
        cb.writeShort(l.size());
        for (String str2 : l) {
            CBUtil.writeString(str2, cb);
        }
    }

    public static int sizeOfStringList(List<String> l) {
        int size = 2;
        for (String str2 : l) {
            size += CBUtil.sizeOfString(str2);
        }
        return size;
    }

    public static Map<String, String> readStringMap(ByteBuf cb) {
        int length = cb.readUnsignedShort();
        HashMap<String, String> m = new HashMap<String, String>(length);
        for (int i = 0; i < length; ++i) {
            String k = CBUtil.readString(cb).toUpperCase();
            String v = CBUtil.readString(cb);
            m.put(k, v);
        }
        return m;
    }

    public static void writeStringMap(Map<String, String> m, ByteBuf cb) {
        cb.writeShort(m.size());
        for (Map.Entry<String, String> entry : m.entrySet()) {
            CBUtil.writeString(entry.getKey(), cb);
            CBUtil.writeString(entry.getValue(), cb);
        }
    }

    public static int sizeOfStringMap(Map<String, String> m) {
        int size = 2;
        for (Map.Entry<String, String> entry : m.entrySet()) {
            size += CBUtil.sizeOfString(entry.getKey());
            size += CBUtil.sizeOfString(entry.getValue());
        }
        return size;
    }

    public static Map<String, List<String>> readStringToStringListMap(ByteBuf cb) {
        int length = cb.readUnsignedShort();
        HashMap<String, List<String>> m = new HashMap<String, List<String>>(length);
        for (int i = 0; i < length; ++i) {
            String k = CBUtil.readString(cb).toUpperCase();
            List<String> v = CBUtil.readStringList(cb);
            m.put(k, v);
        }
        return m;
    }

    public static void writeStringToStringListMap(Map<String, List<String>> m, ByteBuf cb) {
        cb.writeShort(m.size());
        for (Map.Entry<String, List<String>> entry : m.entrySet()) {
            CBUtil.writeString(entry.getKey(), cb);
            CBUtil.writeStringList(entry.getValue(), cb);
        }
    }

    public static int sizeOfStringToStringListMap(Map<String, List<String>> m) {
        int size = 2;
        for (Map.Entry<String, List<String>> entry : m.entrySet()) {
            size += CBUtil.sizeOfString(entry.getKey());
            size += CBUtil.sizeOfStringList(entry.getValue());
        }
        return size;
    }

    public static ByteBuffer readValue(ByteBuf cb) {
        int length = cb.readInt();
        if (length < 0) {
            return null;
        }
        ByteBuf slice = cb.readSlice(length);
        return ByteBuffer.wrap(CBUtil.readRawBytes(slice));
    }

    public static void writeValue(byte[] bytes, ByteBuf cb) {
        if (bytes == null) {
            cb.writeInt(-1);
            return;
        }
        cb.writeInt(bytes.length);
        cb.writeBytes(bytes);
    }

    public static void writeValue(ByteBuffer bytes, ByteBuf cb) {
        if (bytes == null) {
            cb.writeInt(-1);
            return;
        }
        if (bytes == BoundStatement.UNSET) {
            cb.writeInt(-2);
            return;
        }
        cb.writeInt(bytes.remaining());
        cb.writeBytes(bytes.duplicate());
    }

    public static int sizeOfValue(byte[] bytes) {
        return 4 + (bytes == null ? 0 : bytes.length);
    }

    public static int sizeOfValue(ByteBuffer bytes) {
        return 4 + (bytes == null ? 0 : bytes.remaining());
    }

    public static List<ByteBuffer> readValueList(ByteBuf cb) {
        int size = cb.readUnsignedShort();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            l.add(CBUtil.readValue(cb));
        }
        return l;
    }

    public static void writeValueList(List<ByteBuffer> values, ByteBuf cb) {
        cb.writeShort(values.size());
        for (ByteBuffer value2 : values) {
            CBUtil.writeValue(value2, cb);
        }
    }

    public static int sizeOfValueList(List<ByteBuffer> values) {
        int size = 2;
        for (ByteBuffer value2 : values) {
            size += CBUtil.sizeOfValue(value2);
        }
        return size;
    }

    public static void writeNamedValueList(Map<String, ByteBuffer> namedValues, ByteBuf cb) {
        cb.writeShort(namedValues.size());
        for (Map.Entry<String, ByteBuffer> entry : namedValues.entrySet()) {
            CBUtil.writeString(entry.getKey(), cb);
            CBUtil.writeValue(entry.getValue(), cb);
        }
    }

    public static int sizeOfNamedValueList(Map<String, ByteBuffer> namedValues) {
        int size = 2;
        for (Map.Entry<String, ByteBuffer> entry : namedValues.entrySet()) {
            size += CBUtil.sizeOfString(entry.getKey());
            size += CBUtil.sizeOfValue(entry.getValue());
        }
        return size;
    }

    public static InetSocketAddress readInet(ByteBuf cb) {
        byte addrSize = cb.readByte();
        byte[] address = new byte[addrSize];
        cb.readBytes(address);
        int port = cb.readInt();
        try {
            return new InetSocketAddress(InetAddress.getByAddress(address), port);
        }
        catch (UnknownHostException e) {
            throw new DriverInternalError(String.format("Invalid IP address (%d.%d.%d.%d) while deserializing inet address", address[0], address[1], address[2], address[3]));
        }
    }

    public static void writeInet(InetSocketAddress inet, ByteBuf cb) {
        byte[] address = inet.getAddress().getAddress();
        cb.writeByte(address.length);
        cb.writeBytes(address);
        cb.writeInt(inet.getPort());
    }

    public static int sizeOfInet(InetSocketAddress inet) {
        byte[] address = inet.getAddress().getAddress();
        return 1 + address.length + 4;
    }

    public static byte[] readRawBytes(ByteBuf cb) {
        if (cb.hasArray() && cb.readableBytes() == cb.array().length) {
            cb.readerIndex(cb.writerIndex());
            return cb.array();
        }
        byte[] bytes = new byte[cb.readableBytes()];
        cb.readBytes(bytes);
        return bytes;
    }
}

