/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SimpleStatement
extends RegularStatement {
    private final String query;
    private final Object[] values;
    private final Map<String, Object> namedValues;
    private volatile ByteBuffer routingKey;
    private volatile String keyspace;

    public SimpleStatement(String query) {
        this(query, (Object[])null);
    }

    public SimpleStatement(String query, Object ... values) {
        if (values != null && values.length > 65535) {
            throw new IllegalArgumentException("Too many values, the maximum allowed is 65535");
        }
        this.query = query;
        this.values = values;
        this.namedValues = null;
    }

    public SimpleStatement(String query, Map<String, Object> values) {
        if (values.size() > 65535) {
            throw new IllegalArgumentException("Too many values, the maximum allowed is 65535");
        }
        this.query = query;
        this.values = null;
        this.namedValues = values;
    }

    @Override
    public String getQueryString(CodecRegistry codecRegistry) {
        return this.query;
    }

    @Override
    public ByteBuffer[] getValues(ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        if (this.values == null) {
            return null;
        }
        return SimpleStatement.convert(this.values, protocolVersion2, codecRegistry);
    }

    @Override
    public Map<String, ByteBuffer> getNamedValues(ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        if (this.namedValues == null) {
            return null;
        }
        return SimpleStatement.convert(this.namedValues, protocolVersion2, codecRegistry);
    }

    public int valuesCount() {
        if (this.values != null) {
            return this.values.length;
        }
        if (this.namedValues != null) {
            return this.namedValues.size();
        }
        return 0;
    }

    @Override
    public boolean hasValues(CodecRegistry codecRegistry) {
        return this.values != null && this.values.length > 0 || this.namedValues != null && this.namedValues.size() > 0;
    }

    @Override
    public boolean usesNamedValues() {
        return this.namedValues != null && this.namedValues.size() > 0;
    }

    public Object getObject(int i) {
        if (this.values == null) {
            throw new IllegalStateException("This statement does not have positional values");
        }
        if (i < 0 || i >= this.values.length) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.values[i];
    }

    public Object getObject(String name) {
        if (this.namedValues == null) {
            throw new IllegalStateException("This statement does not have named values");
        }
        return this.namedValues.get(name);
    }

    public Set<String> getValueNames() {
        if (this.namedValues == null) {
            throw new IllegalStateException("This statement does not have named values");
        }
        return Collections.unmodifiableSet(this.namedValues.keySet());
    }

    @Override
    public ByteBuffer getRoutingKey(ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        return this.routingKey;
    }

    public SimpleStatement setRoutingKey(ByteBuffer routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    public SimpleStatement setKeyspace(String keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    public SimpleStatement setRoutingKey(ByteBuffer ... routingKeyComponents) {
        this.routingKey = SimpleStatement.compose(routingKeyComponents);
        return this;
    }

    private static ByteBuffer[] convert(Object[] values, ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        ByteBuffer[] serializedValues = new ByteBuffer[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object value2 = values[i];
            if (value2 == null) {
                serializedValues[i] = null;
                continue;
            }
            if (value2 instanceof Token) {
                serializedValues[i] = ((Token)value2).serialize(protocolVersion2);
                continue;
            }
            try {
                TypeCodec<Object> codec = codecRegistry.codecFor(value2);
                serializedValues[i] = codec.serialize(value2, protocolVersion2);
                continue;
            }
            catch (Exception e) {
                throw new InvalidTypeException(String.format("Value %d of type %s does not correspond to any CQL3 type", i, value2.getClass()), e);
            }
        }
        return serializedValues;
    }

    private static Map<String, ByteBuffer> convert(Map<String, Object> values, ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        HashMap<String, ByteBuffer> serializedValues = new HashMap<String, ByteBuffer>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String name = entry.getKey();
            Object value2 = entry.getValue();
            if (value2 == null) {
                serializedValues.put(name, null);
                continue;
            }
            if (value2 instanceof Token) {
                serializedValues.put(name, ((Token)value2).serialize(protocolVersion2));
                continue;
            }
            try {
                TypeCodec<Object> codec = codecRegistry.codecFor(value2);
                serializedValues.put(name, codec.serialize(value2, protocolVersion2));
            }
            catch (Exception e) {
                throw new InvalidTypeException(String.format("Value '%s' of type %s does not correspond to any CQL3 type", name, value2.getClass()), e);
            }
        }
        return serializedValues;
    }

    static ByteBuffer compose(ByteBuffer ... buffers) {
        if (buffers.length == 1) {
            return buffers[0];
        }
        int totalLength = 0;
        for (ByteBuffer bb : buffers) {
            totalLength += 2 + bb.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        for (ByteBuffer buffer : buffers) {
            ByteBuffer bb = buffer.duplicate();
            SimpleStatement.putShortLength(out, bb.remaining());
            out.put(bb);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    static void putShortLength(ByteBuffer bb, int length) {
        bb.put((byte)(length >> 8 & 0xFF));
        bb.put((byte)(length & 0xFF));
    }
}

