/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.mapping.AccessorInvocationHandler;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.MethodMapper;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import shade.com.datastax.spark.connector.google.common.util.concurrent.Futures;
import shade.com.datastax.spark.connector.google.common.util.concurrent.ListenableFuture;

class AccessorMapper<T> {
    final Class<T> daoClass;
    final List<MethodMapper> methods;
    private final Class<T>[] proxyClasses;
    private final AccessorInvocationHandler<T> handler;

    AccessorMapper(Class<T> daoClass, List<MethodMapper> methods2) {
        this.daoClass = daoClass;
        this.methods = methods2;
        this.proxyClasses = new Class[]{daoClass};
        this.handler = new AccessorInvocationHandler(this);
    }

    T createProxy() {
        try {
            return (T)Proxy.newProxyInstance(this.daoClass.getClassLoader(), this.proxyClasses, this.handler);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create instance for Accessor interface " + this.daoClass.getName());
        }
    }

    void prepare(MappingManager manager) {
        ArrayList<ListenableFuture<PreparedStatement>> statements = new ArrayList<ListenableFuture<PreparedStatement>>(this.methods.size());
        for (MethodMapper method2 : this.methods) {
            statements.add(manager.getSession().prepareAsync(method2.queryString));
        }
        try {
            List preparedStatements = (List)Futures.allAsList(statements).get();
            for (int i = 0; i < this.methods.size(); ++i) {
                this.methods.get(i).prepare(manager, (PreparedStatement)preparedStatements.get(i));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error preparing queries for accessor " + this.daoClass.getSimpleName(), e);
        }
    }
}

