package com.dji.wpmzsdk.common.data;

import java.util.List;

import dji.sdk.wpmz.value.mission.WaylineCoordinateParam;
import dji.sdk.wpmz.value.mission.WaylinePayloadParam;

import dji.sdk.wpmz.value.mission.WaylineTemplateWaypointInfo;

/**
 * 模版类
 * 更多了解参考: https://developer.dji.com/doc/cloud-api-tutorial/cn/feature-set/dji-wpml/template-kml.html
 * @description:
 */
public class Template {

    /**
     * 模版id 默认0 参考文档中字段templateId
     * Template id defaults to 0. Refer to the field templateId in the document.
     * refs:templateId
     */
    private Integer templateId;
    /**
     * 坐标系参数
     * Coordinate system parameters
     * refs:waylineCoordinateSysParam
     */
    private WaylineCoordinateParam coordinateParam;
    /**
     * 全局航线过渡速度
     * Global route transition speed
     * refs:globalTransitionalSpeed
     */
    private Double transitionalSpeed;
    /**
     * 是否使 transitionalSpeed 字段生效
     */
    private Boolean useGlobalTransitionalSpeed;
    /**
     * 全局航线飞行速度
     * Global route flight speed
     * refs:autoFlightSpeed
     */
    private Double autoFlightSpeed;
    /**
     * 负载设置
     * payload settings
     * refs:payloadParam
     */
    private List<WaylinePayloadParam> payloadParam;

    /**
     * 航点飞行模板元素
     * Waypoint flight template elements
     */
    private WaylineTemplateWaypointInfo waypointInfo;

    public Integer getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Integer templateId) {
        this.templateId = templateId;
    }

    public WaylineCoordinateParam getCoordinateParam() {
        return coordinateParam;
    }

    public void setCoordinateParam(WaylineCoordinateParam coordinateParam) {
        this.coordinateParam = coordinateParam;
    }

    public Double getTransitionalSpeed() {
        return transitionalSpeed;
    }

    public void setTransitionalSpeed(Double transitionalSpeed) {
        this.transitionalSpeed = transitionalSpeed;
    }

    public Boolean getUseGlobalTransitionalSpeed() {
        return useGlobalTransitionalSpeed;
    }

    public void setUseGlobalTransitionalSpeed(Boolean useGlobalTransitionalSpeed) {
        this.useGlobalTransitionalSpeed = useGlobalTransitionalSpeed;
    }

    public Double getAutoFlightSpeed() {
        return autoFlightSpeed;
    }

    public void setAutoFlightSpeed(Double autoFlightSpeed) {
        this.autoFlightSpeed = autoFlightSpeed;
    }

    public List<WaylinePayloadParam> getPayloadParam() {
        return payloadParam;
    }

    public void setPayloadParam(List<WaylinePayloadParam> payloadParam) {
        this.payloadParam = payloadParam;
    }

    public WaylineTemplateWaypointInfo getWaypointInfo() {
        return waypointInfo;
    }

    public void setWaypointInfo(WaylineTemplateWaypointInfo waypointInfo) {
        this.waypointInfo = waypointInfo;
    }
}
