package com.dji.wpmzsdk.common.utils;

/**
 * @author feel.feng
 * @time 2023/06/30 2:23 下午
 * @description:
 */
public class DJIGpsUtils {
    private static final double ZERO_DEBOUNCE_THRESHOLD = 0.00000001d;
    public static boolean isAvailable(double latitude, double longitude) {
        boolean result = Math.abs(latitude) <= 90
                && Math.abs(longitude) <= 180
                && !(isZero(latitude) && isZero(longitude));
        return result;
    }


    private static boolean isZero(double value) {
        return -ZERO_DEBOUNCE_THRESHOLD <= value && value <= ZERO_DEBOUNCE_THRESHOLD;
    }
}
