package com.dji.wpmzsdk.common.utils

import com.dji.industry.ppal.MappingMaxSpeedInfo
import com.dji.industry.ppal.PPALController
import dji.sdk.wpmz.value.mission.*

/**
 * @author feel.feng
 * @time 2023/06/21 8:36 下午
 * @description:
 */
class PPalGenerator {
    fun getWaylines(param: PPALParam): List<Wayline> {
        param.template.forEach {
            if (it.templateType != WaylineTemplateType.WAYPOINT) {
                throw IllegalArgumentException()
            }
        }
        val waylines = PPALController.generate(
            param.mission.toBytes(),
            param.missionConfig.toBytes(),
            param.template.map { it.toBytes() }).waylines
        return waylines.map { Wayline().apply { fromBytes(it, 0) } }
    }


    /**
     * 计算拍照间隔
     */
    fun calMaxSpeed(missionConfig: WaylineMissionConfig, missionTemplate: WaylineTemplate): MappingMaxSpeedInfo {
        return PPALController.calMaxSpeed(missionConfig.toBytes(), missionTemplate.toBytes())
    }


    data class PPALParam(
        var mission: WaylineMission,
        var missionConfig: WaylineMissionConfig,
        var missionExecutionConfig: WaylineExecuteMissionConfig,
        var template: List<WaylineTemplate>
    ) {
        var needDsmRender: Boolean = false
    }
}