package com.dji.wpmzsdk.common.utils.kml


import com.dji.industry.pilot.data.cache.model.MappingCameraModelGreenDao
import com.dji.industry.pilot.data.cache.model.MappingMissionModelGreenDao
import com.dji.industry.pilot.data.cache.model.MappingWaylineModelGreenDao
import com.dji.wpmzsdk.common.utils.kml.data.MissionType
import com.dji.wpmzsdk.common.utils.kml.mission.WaypointMissionFinishedAction
import com.dji.wpmzsdk.common.utils.kml.model.MissionInfoExtModel
import com.dji.wpmzsdk.common.utils.kml.model.MissionInfoModelGreenDao

import java.util.*

/**
 * Description :
 *
 * @filename : KMLMappingGreenDaoCreateUtil
 * @author : devin.xu
 * @time : 2022/12/1
 *
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/


fun createMappingModel(
    name: String,
    type: MissionType,
    cameraModel: MappingCameraModelGreenDao?
): MappingMissionModelGreenDao {
    val mappingModel = MappingMissionModelGreenDao()
    mappingModel.missionInfo = createMissionInfoMode(name, type)
    mappingModel.mappingWayline =
        if (type == MissionType.Mapping3D) createMapping3DWaylineModel(cameraModel) else createMapping2DWaylineModel(
            cameraModel
        )
    return mappingModel
}

private fun createMissionInfoMode(name: String, type: MissionType): MissionInfoModelGreenDao {
    val info = MissionInfoModelGreenDao()
    info.name = name
    info.type = type
    info.createTime = System.currentTimeMillis()
    info.updateTime = System.currentTimeMillis()
    info.uuid = UUID.randomUUID().toString().replace("-", "_")
    info.extInfo = MissionInfoExtModel()
    return info
}

private fun createMapping2DWaylineModel(cameraModel: MappingCameraModelGreenDao?): MappingWaylineModelGreenDao {
    val waylineModel = MappingWaylineModelGreenDao()
    waylineModel.actionOnFinish = WaypointMissionFinishedAction.GO_HOME
    waylineModel.altitude = MappingUtils.DEF_MAPPING_HEIGHT
    waylineModel.takeoffSpeed = MappingUtils.DEF_MAPPING_TAKEOFF_SPEED
    waylineModel.speed = MappingUtils.DEF_MAPPING_SPEED
    waylineModel.margin = MappingUtils.DEF_MAPPING_MARGIN
    waylineModel.overlapW = MappingUtils.DEF_MAPPING_OVERLAP_W
    waylineModel.overlapH = MappingUtils.DEF_MAPPING_OVERLAP_H
    waylineModel.direction = 0
    waylineModel.type = MissionType.Mapping2D
    waylineModel.camera = cameraModel
    waylineModel.dsmAltitude = MappingUtils.DEF_MAPPING_DSM_HEIGHT
    waylineModel.fiveWayPoseWithGimbalPitch = MappingUtils.DEF_MAPPING_GIMBAL_PITCH
    waylineModel.scanMode = MappingUtils.LIDAR_SCANMODE_REPEAT
    waylineModel.needVariegation = true // 默认打开点云上色
    return waylineModel
}

fun createMapping3DWaylineModel(cameraModel: MappingCameraModelGreenDao?): MappingWaylineModelGreenDao {
    val waylineModel = MappingWaylineModelGreenDao()
    waylineModel.actionOnFinish = WaypointMissionFinishedAction.GO_HOME
    waylineModel.altitude = MappingUtils.DEF_MAPPING_HEIGHT
    waylineModel.takeoffSpeed = MappingUtils.DEF_MAPPING_TAKEOFF_SPEED
    waylineModel.speed = MappingUtils.DEF_MAPPING_SPEED
    waylineModel.margin = MappingUtils.DEF_MAPPING_MARGIN
    waylineModel.overlapW = MappingUtils.DEF_MAPPING_OVERLAP_W
    waylineModel.overlapH = MappingUtils.DEF_MAPPING_OVERLAP_H
    waylineModel.direction = 0
    waylineModel.type = MissionType.Mapping3D
    waylineModel.camera = cameraModel
    waylineModel.inclineOverlapH = MappingUtils.DEF_MAPPING_INCLINE_OVERLAP_H
    waylineModel.inclineOverlapW = MappingUtils.DEF_MAPPING_INCLINE_OVERLAP_W
    waylineModel.inclineSpeed = MappingUtils.DEF_MAPPING_SPEED
    waylineModel.gimbalPitch = MappingUtils.DEF_MAPPING_GIMBAL_PITCH
    waylineModel.scanMode = MappingUtils.LIDAR_SCANMODE_REPEAT
    waylineModel.needVariegation = true // 默认打开点云上色
    return waylineModel
}