package com.dji.wpmzsdk.common.utils.kml


import com.dji.industry.pilot.data.cache.model.MappingCameraModelGreenDao
import com.dji.wpmzsdk.common.utils.kml.model.MissionInfoModelGreenDao
import com.dji.industry.pilot.data.cache.model.StripMissionModelGreenDao
import com.dji.industry.pilot.data.cache.model.StripWaylineModelGreenDao

import com.dji.wpmzsdk.common.utils.kml.data.MissionType
import com.dji.wpmzsdk.common.utils.kml.mission.WaypointMissionFinishedAction

import java.util.*

/**
 * Description :
 *
 * @filename : KMLStripGreenDaoCreateUtil
 * @author : devin.xu
 * @time : 2022/12/1
 *
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/


fun createStripModel(
    name: String,
    type: MissionType,
    cameraModel: MappingCameraModelGreenDao?
): StripMissionModelGreenDao {
    val stripModel = StripMissionModelGreenDao()
    stripModel.missionInfo = createMissionInfoMode(name, type)
    stripModel.stripWayline = createStripWaylineModel(cameraModel)
    return stripModel
}

private fun createMissionInfoMode(name: String, type: MissionType): MissionInfoModelGreenDao {
    val info = MissionInfoModelGreenDao()
    info.name = name
    info.type = type
    info.createTime = System.currentTimeMillis()
    info.updateTime = System.currentTimeMillis()
    info.uuid = UUID.randomUUID().toString().replace("-", "_")
    return info
}


private fun createStripWaylineModel(cameraModel: MappingCameraModelGreenDao?): StripWaylineModelGreenDao {
    val waylineModel = StripWaylineModelGreenDao()
    waylineModel.actionOnFinish = WaypointMissionFinishedAction.GO_HOME
    waylineModel.altitude = StripUtils.DEF_STRIP_HEIGHT
    waylineModel.takeoffSpeed = StripUtils.DEF_STRIP_TAKEOFF_SPEED
    waylineModel.speed = StripUtils.DEF_STRIP_SPEED
    waylineModel.overlapW = StripUtils.DEF_STRIP_OVERLAP_W
    waylineModel.overlapH = StripUtils.DEF_STRIP_OVERLAP_H
    waylineModel.type = MissionType.Strip
    waylineModel.camera = cameraModel
    waylineModel.hasCenterLine = false
    waylineModel.cutLength = StripUtils.DEF_STRIP_CUT_DISTANCE
    waylineModel.leftExtend = StripUtils.DEF_STRIP_LEFT_EXTAND_DISTANCE
    waylineModel.rightExtend = StripUtils.DEF_STRIP_RIGHT_EXTAND_DISTANCE
    waylineModel.planMode = StripUtils.DEF_STRIP_TASK_MODE
    waylineModel.enableCalibrate = false
    waylineModel.scanMode = MappingUtils.LIDAR_SCANMODE_REPEAT
    waylineModel.needVariegation = false
    return waylineModel
}
