package com.dji.wpmzsdk.common.utils.kml


import com.dji.wpmzsdk.common.utils.kml.data.DroneInfoModel
import com.dji.wpmzsdk.common.utils.kml.data.MissionType
import com.dji.wpmzsdk.common.utils.kml.mission.*
import com.dji.wpmzsdk.common.utils.kml.model.*

import java.util.*

/**
 * Description :
 *
 * @filename : KMLMissionEntityCreateUtil
 * @author : devin.xu
 * @time : 2022/12/1
 *
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
fun createWaypointMissionModel(name: String): WaypointMissionModelGreenDao {
    val mission = WaypointMissionModelGreenDao()
    mission.missionInfo = createMissionInfoModel(name)
    mission.wayline = createWaylineModel()
    mission.waypoints = ArrayList()
    return mission
}

fun createMissionInfoModel(name: String): MissionInfoModelGreenDao {
    val model = MissionInfoModelGreenDao()
    model.id = 0L
    model.name = name
    model.type = MissionType.Waypoint
    model.createTime = System.currentTimeMillis()
    model.updateTime = System.currentTimeMillis()
    model.uuid = UUID.randomUUID().toString().replace("-", "_")
    val extInfo = MissionInfoExtModel()
    extInfo.createType = MissionCreateType.MAP
    model.extInfo = extInfo
    return model
}

fun createWaylineModel(): WaylineModelGreenDao {
    val model = WaylineModelGreenDao()
    model.altitude = SettingUtils.DEF_WAYLINE_HEIGHT
    model.autoFlightSpeed = SettingUtils.DEF_WAYLINE_SPEED
    model.gotoFirstPointMode = WaypointMissionGotoWaypointMode.GotoWaypointSafely
    model.actionOnFinish = WaypointMissionFinishedAction.GO_HOME
    model.headingMode = WaypointMissionHeadingMode.AUTO
    model.exitOnRCLost = true
    model.gimbalPitchRotationEnable = false
    model.droneInfo = createDroneInfoModel()
    model.waypointType = WaypointV2MissionTypes.WaypointV2FlightPathMode.GOTO_POINT_STRAIGHT_LINE_AND_STOP
    return model
}

fun createDroneInfoModel(): DroneInfoModel {
    val model = DroneInfoModel()
    model.droneType = WaypointDroneType.PM430
    return model
}

fun createWaypointModel(): WaypointModelGreenDao {
    val waypointModel = WaypointModelGreenDao()
    waypointModel.altitude = SettingUtils.DEF_WAYLINE_HEIGHT
    waypointModel.speed = SettingUtils.DEF_WAYPOINT_SPEED
    waypointModel.useWaylineAltitude = true
    waypointModel.useWaylineSpeed = true
    waypointModel.heading = 0
    waypointModel.cornerRadius = SettingUtils.DEF_WAYPOINT_RADIUS
    waypointModel.gimbalPitch = 0f
    waypointModel.turnMode = PointTurnMode.AUTO
    waypointModel.useWaylineHeadMode = true
    waypointModel.useWaylinePointType = true
    waypointModel.actions = mutableListOf()
    return waypointModel
}

