package com.dji.wpmzsdk.common.utils.kml;
/*
 *   WWWWWW||WWWWWW
 *    W W W||W W W
 *         ||
 *       ( OO )__________
 *        /  |           \
 *       /o o|    DJI     \
 *       \___/||_||__||_|| **
 *            || ||  || ||
 *           _||_|| _||_||
 *          (__|__|(__|__|
 *
 * Copyright (c) 2020, DJI All Rights Reserved.
 */



import static com.dji.wpmzsdk.common.utils.kml.MappingUtils.DEF_MAPPING_DSM_HEIGHT;

import com.dji.wpmzsdk.common.utils.kml.data.MissionType;
import com.dji.wpmzsdk.common.utils.kml.mission.MissionInfoModel;
import com.dji.wpmzsdk.common.utils.kml.mission.WaypointMissionFinishedAction;
import com.dji.wpmzsdk.common.utils.kml.model.MappingCameraModel;
import com.dji.wpmzsdk.common.utils.kml.model.MappingCameraType;
import com.dji.wpmzsdk.common.utils.kml.model.StripMissionModel;
import com.dji.wpmzsdk.common.utils.kml.model.StripWaylineModel;

import java.util.List;
import java.util.UUID;


import dji.sdk.wpmz.value.mission.WaylineExitOnRCLostAction;

/**
 * @author create at 2020/06/10 by otto.ouyang for dji-pilot
 */
public class StripUtils {


    private final static String TAG = StripUtils.class.getSimpleName();
    // Camera Interval
    public static final float MIN_SHOT_INTERVAL = 1f;
    public static final float MAX_SHOT_INTERVAL = 10f;
    public static final float DEF_CAMERA_SHOT_INTERVAL = 2.5f;
    public static final float DEF_GD610_CAMERA_SHOT_INTERVAL = 3.0f;
    public static final int DEF_CAMERA_IMAGE_WIDTH = 3000;
    public static final int DEF_CAMERA_IMAGE_HEIGHT = 3000;
    public static final float DEF_CAMERA_SENSOR_WIDTH = 10f;
    public static final float DEF_CAMERA_SENSOR_HEIGHT = 10f;
    public static final float DEF_CAMERA_FOCAL_LENGTH = 10f;

    public static final float DEF_STRIP_SPEED = 15;
    public static final float DEF_STRIP_TAKEOFF_SPEED = 10;
    public static final int DEF_STRIP_HEIGHT = 100;
    public static final int DEF_STRIP_OVERLAP_W = 70;
    public static final int DEF_STRIP_OVERLAP_H = 80;
    public static final int DEF_STRIP_LEFT_EXTAND_DISTANCE = 50;
    public static final int DEF_STRIP_RIGHT_EXTAND_DISTANCE = 50;
    public static final int DEF_STRIP_CUT_DISTANCE = 500;
    public static final int DEF_STRIP_TASK_MODE = 0;
    public static final float DEF_STRIP_SECURE_TAKEOFF_HEIGHT = 20F;


//    public static void applySettings(StripWaylineModel model, StripBasicModel viewModel) {
//        model.setAltitude(viewModel.getAltitude());
//        model.setWgs84Altitude(viewModel.getWgs84Altitude());
//        model.setTakeoffSpeed(viewModel.getTakeoffSpeed());
//        model.setSpeed(viewModel.getSpeed());
//        model.setActionOnFinish(viewModel.getCompletion().getValue());
//        model.setPhotoMode(viewModel.getPhotoMode());
//        model.setLeftExtend(viewModel.getLeftExtandDistance());
//        model.setRightExtend(viewModel.getRightExtandDistance());
//        model.setCutLength(viewModel.getCutDistance());
//        model.setHasCenterLine(viewModel.isIncludeCenterLine());
//        model.setPlanMode(viewModel.getTaskMode());
//        model.setEnableSingleLine(viewModel.isEnableSingleLine());
//        model.setAltitudeMode(viewModel.getAltitudeMode());
//        model.setRelativeDistance(viewModel.getRelativeDistance());
//        model.setStripEnableDsm(viewModel.isEnableDsm());
//        model.setStripDsmAltitude(viewModel.getDsmAltitude());
//        model.setStripRealtimeSurfaceFollow(viewModel.isRealtimeSurfaceFollow());
//        if (viewModel.getCameraType() == MappingCameraType.OTHER) {
//            model.setCamera(viewModel.getStripCameraModel());
//        } else {
//            model.setCamera(createStripCameraModel(viewModel.getCameraType()));
//        }
//        model.setEnableCalibrate(viewModel.isEnableCalibrate());
//        model.setStripSecureTakeoffHeight(viewModel.getStripSecTakeoffHeight());
//        model.setStripInclineClimbEnable(viewModel.isInclineClimbEnable());
//    }
//
//    public static void applySettings(StripWaylineModel model, StripAdvancedModel viewModel) {
//        model.setOverlapH(viewModel.getOverlapH());
//        model.setOverlapW(viewModel.getOverlapW());
//    }
//
//    public static void applySettings(StripWaylineModel model, CameraAdvancedModel viewModel) {
//        model.setEnableDewarping(viewModel.isDewarpEnable());
//        model.setPhotoFormat(viewModel.getPhotoFormat());
//        model.setFocusMode(viewModel.getWaylineFocusMode());
//        model.setEchoMode(viewModel.getEchoMode());
//        model.setSampleRate(viewModel.getSampleRate());
//        model.setScanMode(viewModel.getScanMode());
//        model.setNeedVariegation(viewModel.isNeedVariegation());
//    }

    public static StripMissionModel createStripModel(String name, MissionType type, MappingCameraModel cameraModel) {
        StripMissionModel stripModel = new StripMissionModel();
        stripModel.setMissionInfo(createMissionInfoMode(name, type));
        stripModel.setStripWayline(createStripWaylineModel(cameraModel));
        return stripModel;
    }

    private static MissionInfoModel createMissionInfoMode(String name, MissionType type) {
        MissionInfoModel info = new MissionInfoModel();
        info.setName(name);
        info.setType(type);
        info.setCreateTime(System.currentTimeMillis());
        info.setUpdateTime(System.currentTimeMillis());
        info.setCollected(false);
        info.setUuid(UUID.randomUUID().toString().replace("-", "_"));
        return info;
    }

    private static StripWaylineModel createStripWaylineModel(MappingCameraModel cameraModel) {
        StripWaylineModel waylineModel = new StripWaylineModel();
        waylineModel.setActionOnFinish(WaypointMissionFinishedAction.GO_HOME);

        waylineModel.setAltitude(DEF_STRIP_HEIGHT);
        waylineModel.setTakeoffSpeed(DEF_STRIP_TAKEOFF_SPEED);
        waylineModel.setSpeed(DEF_STRIP_SPEED);
        waylineModel.setOverlapW(DEF_STRIP_OVERLAP_W);
        waylineModel.setOverlapH(DEF_STRIP_OVERLAP_H);
        waylineModel.setType(MissionType.Strip);
        waylineModel.setCamera(cameraModel);
        waylineModel.setHasCenterLine(false);
        waylineModel.setCutLength(DEF_STRIP_CUT_DISTANCE);
        waylineModel.setLeftExtend(DEF_STRIP_LEFT_EXTAND_DISTANCE);
        waylineModel.setRightExtend(DEF_STRIP_RIGHT_EXTAND_DISTANCE);
        waylineModel.setPlanMode(DEF_STRIP_TASK_MODE);
        waylineModel.setEnableCalibrate(false);
        waylineModel.setScanMode(MappingUtils.LIDAR_SCANMODE_REPEAT);
        waylineModel.setNeedVariegation(false);
        waylineModel.setLostAction(WaylineExitOnRCLostAction.GO_BACK);
        waylineModel.setStripSecureTakeoffHeight(DEF_STRIP_SECURE_TAKEOFF_HEIGHT);
        waylineModel.setStripInclineClimbEnable(false);
        waylineModel.setStripDsmAltitude(DEF_MAPPING_DSM_HEIGHT);
        return waylineModel;
    }

//    public static CameraAdvancedModel createCameraAdvanceSetting(StripWaylineModel waylineModel) {
//        final CameraAdvancedModel cameraAdvancedModel = new CameraAdvancedModel();
//        cameraAdvancedModel.setDewarpEnable(waylineModel.isEnableDewarping());
//        cameraAdvancedModel.setPhotoFormat(waylineModel.getPhotoFormat());
//        cameraAdvancedModel.setWaylineFocusMode(waylineModel.getFocusMode());
//        cameraAdvancedModel.setEchoMode(waylineModel.getEchoMode());
//        cameraAdvancedModel.setSampleRate(waylineModel.getSampleRate());
//        cameraAdvancedModel.setScanMode(waylineModel.getScanMode());
//        cameraAdvancedModel.setNeedVariegation(waylineModel.isNeedVariegation());
//        return cameraAdvancedModel;
//    }

//    public static String getSelectedCameraName() {
//        return SharedPreferencesUtil.getString(Constant.STRIP_CAMERA_SELECTED, MappingCameraType.EP600_35MM.getNameStr(), false);
//    }
//
//    public static void saveSelectedCameraName(MappingCameraModel model) {
//        SharedPreferencesUtil.putString(Constant.STRIP_CAMERA_SELECTED, model.getName(), false);
//    }

    public static MappingCameraModel createStripCameraModel(MappingCameraType cameraType) {
        if (cameraType != MappingCameraType.OTHER) {
            MappingCameraModel cameraModel = new MappingCameraModel();
            cameraModel.setName(cameraType.getNameStr());
            cameraModel.setSensorWidth(cameraType.getSensorW());
            cameraModel.setSensorHeight(cameraType.getSensorH());
            cameraModel.setFocalLength(cameraType.getFocalLength());
            cameraModel.setImageHeight(cameraType.getImageHeight());
            cameraModel.setImageWidth(cameraType.getImageWidth());
            cameraModel.setShotInterval(MappingUtils.getCameraShotInterval(cameraType, false));
            return cameraModel;
        }
        return null;
    }

//    public static StripBasicModel createBasicSetting(StripWaylineModel waylineModel) {
//        StripBasicModel model = new StripBasicModel();
//        model.setAltitude(waylineModel.getAltitude());
//        model.setTakeoffSpeed(waylineModel.getTakeoffSpeed());
//        initBasicSettingCameraType(waylineModel, model);
//        model.setSpeed(waylineModel.getSpeed());
//        model.getCompletion().setValue(waylineModel.getActionOnFinish());
//        model.setPhotoMode(waylineModel.getPhotoMode());
//        model.setLeftExtandDistance(waylineModel.getLeftExtend());
//        model.setRightExtandDistance(waylineModel.getRightExtend());
//        model.setCutDistance(waylineModel.getCutLength());
//        model.setIncludeCenterLine(waylineModel.isHasCenterLine());
//        model.setTaskMode(waylineModel.getPlanMode());
//        model.setEnableSingleLine(waylineModel.isEnableSingleLine());
//        model.setAltitudeMode(waylineModel.getAltitudeMode());
//        model.setRelativeDistance(waylineModel.getRelativeDistance());
//        model.setEnableCalibrate(waylineModel.isEnableCalibrate());
//        model.setStripSecTakeoffHeight(waylineModel.getStripSecureTakeoffHeight());
//        model.setEnableDsm(waylineModel.isStripEnableDsm());
//        model.setDsmAltitude(waylineModel.getStripDsmAltitude());
//        model.setRealtimeSurfaceFollow(waylineModel.isStripRealtimeSurfaceFollow());
//        model.setInclineClimbEnable(waylineModel.isStripInclineClimbEnable());
//        return model;
//    }
//
//    private static void initBasicSettingCameraType(StripWaylineModel waylineModel, StripBasicModel model) {
//        if (waylineModel == null || waylineModel.getCamera() == null) {
//            return;
//        }
//        String name = waylineModel.getCamera().getName();
//        model.setCameraType(null);
//        for (MappingCameraType type : MappingCameraType.values()) {
//            if (type.getNameStr().equals(name) && type != MappingCameraType.OTHER) {
//                model.setCameraType(type);
//                break;
//            }
//        }
//        if (model.getCameraType() == null) {
//            model.setCameraType(MappingCameraType.OTHER);
//            model.setStripCameraModel(waylineModel.getCamera());
//        }
//    }

//    public static StripAdvancedModel createAdvanceSetting(StripWaylineModel waylineModel) {
//        StripAdvancedModel model = new StripAdvancedModel();
//        model.setOverlapH(waylineModel.getOverlapH());
//        model.setOverlapW(waylineModel.getOverlapW());
//        return model;
//    }

    //航线库中copy操作，航线name，creatTime，updateTime等会改变。
//    public static StripMissionModel copyStripMission(StripMissionModel stripMissionModel, String name) {
//        StripMissionModel model = stripMissionModel.clone();
//
//        if (model != null) {
//            model.setId(null);
//            handleCopiedStripWayline(model.getStripWayline());
//            String diagram = stripMissionModel.getMissionInfo().getDiagram();
//            WaypointUtils.handleCopiedMissionInfo(model.getMissionInfo(), name, diagram);
//        }
//        return model;
//    }

    private static void handleCopiedStripWayline(StripWaylineModel waylineModel) {
        if (waylineModel != null) {
            waylineModel.setId(null);
        }
    }


    public static float getMaxSpeedValue(double distance, double shotInterval) {
        //航向拍照距离  除以 相机的最小拍照间隔 就是 测绘飞行中的最大速度阈值
        return (float) (distance / shotInterval);
    }

    public static void createDsmSetting(List<String> models, StripWaylineModel waylineModel) {
        final List<String> paths = waylineModel.getStripDsmPath();
        if (paths == null) {
            return;
        }
        models.addAll(paths);
    }


}
