package com.dji.wpmzsdk.common.utils.kml.converter


import com.dji.industry.pilot.data.cache.model.*


import com.dji.wpmzsdk.common.utils.FileUtils
import com.dji.wpmzsdk.common.utils.PPalGenerator
import com.dji.wpmzsdk.common.utils.kml.model.*
import com.dji.wpmzsdk.common.utils.kml.transfrom.MappingMissionEntityTransform
import com.dji.wpmzsdk.common.utils.kml.transfrom.MissionTransformData
import com.dji.wpmzsdk.common.utils.kml.transfrom.StripMissionEntityTransform
import com.dji.wpmzsdk.common.utils.kml.transfrom.WaypointMissionEntityTransform
import java.io.File
import kotlin.math.max

/**
 * Description :
 *
 * @filename : MissionGreenDaoTransform
 * @author : devin.xu
 * @time : 2022/11/30
 *
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
class MissionGreenDaoTransform {

    fun generateGreenDaoMissionWayline(entity: Any): MissionTransformData {
        return when (entity) {
            is MappingMissionModelGreenDao -> {
                generateMappingKMLWayline(entity)
            }
            is StripMissionModelGreenDao -> {
                generateStripKMLWayline(entity)
            }
            is WaypointMissionModelGreenDao -> {
                generateWaypointKMLWayline(entity)
            }
            else -> MissionTransformData()
        }

    }


//    fun generateGreenDaoWaypointMission(model: WaypointMissionModelGreenDao, type: WaypointDroneType): MissionTransformData {
//        val sourceDroneType = model.wayline!!.droneInfo!!.droneType
//        val destDroneInfo = MissionWaypointDroneTypeUtil().getDestDroneInfo(sourceDroneType, type)
//        val transformData = WaypointMissionEntityTransform().trans(model)
//        transformData.missionConfig.securityTakeOffHeight = 2.0
//
//        val convertInfo = WPMZ.getDroneTypeChangeContent(transformData.missionConfig, transformData.templates, destDroneInfo.droneInfo, destDroneInfo.payloadInfos)
//        transformData.missionConfig = convertInfo.missionConfig
//        transformData.templates = convertInfo.templates
//        transformData.executeMissionConfig = createExecuteConfig(convertInfo.missionConfig)
//
//        val ppalParam = WaylinePPALGenerator.PPALParam(transformData.mission, transformData.missionConfig, transformData.executeMissionConfig, transformData.templates);
//        transformData.wayline = WaylinePPALGenerator().getWaylines(ppalParam)
//        return transformData
//    }


    private fun generateMappingKMLWayline(model: MappingMissionModelGreenDao): MissionTransformData {
        val mappingWayline = model.mappingWayline!!
        if (MappingCameraType.find(mappingWayline.camera!!.name) != MappingCameraType.EP800_LIDAR) {
            mappingWayline.enableCalibrate = false
        }
        if (mappingWayline.enableDsm && mappingWayline.dsmPath.isNullOrEmpty()) {
            mappingWayline.enableDsm = false
        }
        if (mappingWayline.enableDsm) {
            mappingWayline.altitudeMode = 1;//AltitudeMode.ABSOLUTE todo
        }
        val transformData = MappingMissionEntityTransform().transFrom(model)

        val generator = PPalGenerator()
        val speedInfo = generator.calMaxSpeed(transformData.missionConfig, transformData.templates[0])
        val speed = max(1f, speedInfo.orthoMaxSpeed)
        if (mappingWayline.speed >= speed || mappingWayline.fiveWayPose) {
            val waylineTemplate = transformData.templates[0]
            waylineTemplate.autoFlightSpeed = speed.toDouble()
        }
        val ppalParam = PPalGenerator.PPALParam(transformData.mission, transformData.missionConfig, transformData.executeMissionConfig, transformData.templates);
        transformData.wayline = generator.getWaylines(ppalParam)
        return transformData
    }


    private fun generateStripKMLWayline(model: StripMissionModelGreenDao): MissionTransformData {
        val transformData = StripMissionEntityTransform().transFrom(model)
        val ppalParam = PPalGenerator.PPALParam(transformData.mission, transformData.missionConfig, transformData.executeMissionConfig, transformData.templates);

        transformData.wayline = PPalGenerator().getWaylines(ppalParam)
        return transformData
    }

    private fun generateWaypointKMLWayline(model: WaypointMissionModelGreenDao): MissionTransformData {
        model.waypoints.forEach { kmlPreciseInfoConvert(it) }
        val transformData = WaypointMissionEntityTransform().trans(model)

        val ppalParam = PPalGenerator.PPALParam(transformData.mission, transformData.missionConfig, transformData.executeMissionConfig, transformData.templates);
        transformData.wayline = PPalGenerator().getWaylines(ppalParam)
        return transformData
    }

    private fun kmlPreciseInfoConvert(waypointModel: WaypointModelGreenDao) {
        if (!waypointModel.preciseShotInfo.isNullOrEmpty()) {
            waypointModel.actions.removeAll { action -> action.preciseInfoName != null }

            waypointModel.preciseShotInfo.forEach { item ->
                val file = File(item.cacheFilePath, item.cacheFileName)
                var md5 = FileUtils.getFileMD5(file)
                if (md5 != null) {
                    md5 = md5.substring(8, 24)
                }
                item.fileMD5 = md5

                val preciseAction = WaypointActionModelGreenDao()
                preciseAction.cameraIndex = item.cameraIndex
                preciseAction.preciseInfoName = item.cacheFileName
                if (item.cropWidth > 0 && item.fileMD5 != null) {
                    preciseAction.actionType = WaypointActionType.PRECISE_SHOT
                } else {
                    preciseAction.actionType = WaypointActionType.NORMAL_PRECISE_SHOT
                }
                waypointModel.actions.add(preciseAction)
            }
        }
    }

}