package com.dji.wpmzsdk.common.utils.kml.converter


import com.dji.wpmzsdk.common.utils.kml.mission.WaypointV2MissionTypes
import dji.sdk.wpmz.value.mission.WaylineWaypointTurnMode

/**
 * Description :
 *
 * @filename : PilotWaypointType
 * @author : devin.xu
 * @time : 2022/3/10
 *
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
enum class PilotWaypointTurnMode {

    /**
     * 协调转弯
     */
    COORDINATE_TURN,

    /**
     * 直线飞行到点停
     */
    POINT_STOP_STRAIGHT,

    /**
     * 平滑过点
     */
    POINT_PASS_SMOOTH,

    /**
     * 曲线飞行到点停
     */
    POINT_STOP_CURVATURE,

    /**
     * 曲线飞行到点不停
     */
    POINT_PASS_CURVATURE;

}

fun convert(v2FlightPathMode: WaypointV2MissionTypes.WaypointV2FlightPathMode): PilotWaypointTurnMode {
    return when(v2FlightPathMode) {
        WaypointV2MissionTypes.WaypointV2FlightPathMode.COORDINATE_TURN -> PilotWaypointTurnMode.COORDINATE_TURN
        WaypointV2MissionTypes.WaypointV2FlightPathMode.GOTO_POINT_STRAIGHT_LINE_AND_STOP -> PilotWaypointTurnMode.POINT_STOP_STRAIGHT
        WaypointV2MissionTypes.WaypointV2FlightPathMode.GOTO_POINT_CURVE_AND_STOP -> PilotWaypointTurnMode.POINT_STOP_CURVATURE
        WaypointV2MissionTypes.WaypointV2FlightPathMode.CURVATURE_CONTINUOUS_PASSED -> PilotWaypointTurnMode.POINT_PASS_CURVATURE
        else -> PilotWaypointTurnMode.POINT_STOP_STRAIGHT
    }
}