package com.dji.wpmzsdk.common.utils.kml.converter



import com.dji.wpmzsdk.common.utils.PPalGenerator
import com.dji.wpmzsdk.common.utils.kml.model.MappingMissionModel
import com.dji.wpmzsdk.common.utils.kml.model.StripMissionModel
import com.dji.wpmzsdk.common.utils.kml.model.WaypointMissionModel
import com.dji.wpmzsdk.common.utils.kml.transfrom.MappingTemplateTransform
import com.dji.wpmzsdk.common.utils.kml.transfrom.MissionTransformData
import com.dji.wpmzsdk.common.utils.kml.transfrom.StripTemplateTransform
import com.dji.wpmzsdk.common.utils.kml.transfrom.WaypointTemplateTransform
import dji.sdk.wpmz.jni.JNIWPMZManager
import dji.sdk.wpmz.value.mission.*
import java.io.IOException

/**
 * Description :
 *
 * @filename : WaylineConverter
 * @author : devin.xu
 * @time : 2021/11/12
 *
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
class WaylineConverter {

    companion object {
       const val TAG = "WaylineConverter"
    }

//    fun convert(
//            wayline: Wayline,
//            missionConfig: WaylineExecuteMissionConfig,
//            missionId: Int,
//            finishAction: WaylineFinishedAction,
//    ): WaypointMissionV2Impl {
//        val waylineData = JNIWPMZManager.ConvertV3MissionToV2(wayline, missionConfig)
//        val actionData = JNIWPMZManager.ConvertV3ActionsToV2(wayline.actionGroups)
//
//        val absoluteHeight = wayline.mode == WaylineExecuteAltitudeMode.WGS84
//        val exitOnRcLost = missionConfig.exitOnRCLostType != WaylineExitOnRCLostAction.UNKNOWN
//        return WaypointMissionV2Impl(convertMission(waylineData, missionId, convertFinishAction(finishAction), exitOnRcLost), convertAction(actionData), absoluteHeight)
//    }

//    private fun convertFinishAction(waylineFinishAction: WaylineFinishedAction): WaypointV2MissionTypes.MissionFinishedAction {
//        return when (waylineFinishAction) {
//            WaylineFinishedAction.NO_ACTION -> WaypointV2MissionTypes.MissionFinishedAction.NO_ACTION
//            WaylineFinishedAction.GO_HOME -> WaypointV2MissionTypes.MissionFinishedAction.GO_HOME
//            WaylineFinishedAction.AUTO_LAND -> WaypointV2MissionTypes.MissionFinishedAction.AUTO_LAND
//            WaylineFinishedAction.GOTO_FIRST_WAYPOINT -> WaypointV2MissionTypes.MissionFinishedAction.GO_FIRST_WAYPOINT
//            else -> WaypointV2MissionTypes.MissionFinishedAction.GO_HOME
//        }
//    }
//
//    private fun convertMission(data: ByteArray, missionId: Int, finishAction: WaypointV2MissionTypes.MissionFinishedAction, exitOnRcLost: Boolean): WaypointV2Mission? {
//        var mission: WaypointMission? = null
//        try {
//            mission = WaypointMission.ADAPTER.decode(data)
//            AirlineLog.log(TAG, "decode WaypointMission:\n$mission")
//        } catch (e: IOException) {
//            AirlineLog.log(TAG, "decode WaypointMission error:" + e.message)
//        }
//        return WaypointV2Abstraction.convertFromJNIV2WaypointMission(mission, missionId, finishAction, exitOnRcLost)
//    }
//
//    private fun convertAction(data: List<ByteArray>): List<WaypointV2Action> {
//        val actions: MutableList<WaypointV2Action> = mutableListOf()
//
//        data.forEach {
//            var config: WaypointActionConfig? = null
//            try {
//                config = WaypointActionConfig.ADAPTER.decode(it)
//            } catch (e: IOException) {
//                AirlineLog.log(TAG, "decode WaypointV2Action error:" + e.message)
//            }
//            if (config != null) {
//                val v2Action = WaypointV2Abstraction.convertFromJNIWaypointActionConfig(config)
//                if (v2Action != null) {
//                    actions.add(v2Action)
//                }
//            }
//        }
//
//        return actions
//    }

    fun generateKMLWayline(model: Any): MissionTransformData {
        return when (model) {
            is MappingMissionModel -> {
                generateMappingKMLWayline(model)
            }
            is StripMissionModel -> {
                generateStripKMLWayline(model)
            }
            is WaypointMissionModel -> {
                generateWaypointKMLWayline(model)
            }
            else -> MissionTransformData()
        }

    }

    fun generateKMZTemplateWayline(transformData: MissionTransformData): List<Wayline> {
        val ppalParam = PPalGenerator.PPALParam(transformData.mission, transformData.missionConfig, transformData.executeMissionConfig, transformData.templates);
        return PPalGenerator().getWaylines(ppalParam)
    }

    private fun generateMappingKMLWayline(model: MappingMissionModel): MissionTransformData {
        val generator = PPalGenerator()

        val templateTransform = MappingTemplateTransform()
        val transformData = templateTransform.transFrom(model)
        val ppalParam = PPalGenerator.PPALParam(transformData.mission, transformData.missionConfig, transformData.executeMissionConfig, transformData.templates);

        transformData.wayline = generator.getWaylines(ppalParam)
        return transformData
    }

    private fun generateStripKMLWayline(model: StripMissionModel): MissionTransformData {
        val templateTransform = StripTemplateTransform()
        val transformData = templateTransform.transFrom(model)
        val ppalParam = PPalGenerator.PPALParam(transformData.mission, transformData.missionConfig, transformData.executeMissionConfig, transformData.templates);

        transformData.wayline = PPalGenerator().getWaylines(ppalParam)
        return transformData
    }

    private fun generateWaypointKMLWayline(model: WaypointMissionModel): MissionTransformData {
        val templateTransform = WaypointTemplateTransform()
        val transformData = templateTransform.transFrom(model)
        val ppalParam = PPalGenerator.PPALParam(transformData.mission, transformData.missionConfig, transformData.executeMissionConfig, transformData.templates);

        transformData.wayline = PPalGenerator().getWaylines(ppalParam)
        return transformData
    }



}