package com.dji.wpmzsdk.common.utils.kml.data;

import android.os.Parcel;


import com.dji.wpmzsdk.common.utils.kml.CollectionUtil;
import com.dji.wpmzsdk.common.utils.kml.model.CameraType;
import com.dji.wpmzsdk.common.utils.kml.model.CameraUtil;
import com.dji.wpmzsdk.common.utils.kml.model.DroneCameraModel;
import com.dji.wpmzsdk.common.utils.kml.model.DroneHeightModel;
import com.dji.wpmzsdk.common.utils.kml.model.PayloadCameraType;
import com.dji.wpmzsdk.common.utils.kml.model.WaypointDroneType;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


/**
 * Description :
 *
 * @author : devin.xu
 * @filename : DroneInfoModel
 * @time : 2019-07-29
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public class DroneInfoModel implements Cloneable {

    private Long id;

    private WaypointDroneType droneType;

    private List<DroneCameraModel> cameras = new ArrayList<>();

    private DroneHeightModel droneHeight = new DroneHeightModel();

    public DroneInfoModel() {
    }



    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public WaypointDroneType getDroneType() {
        return droneType;
    }

    public void setDroneType(WaypointDroneType droneType) {
        this.droneType = droneType;
    }

    public void setDroneCamera(List<DroneCameraModel> cameraList) {
        this.cameras.clear();
        if (cameraList != null) {
            cameras.addAll(cameraList);
        }
    }

    public DroneHeightModel getDroneHeight() {
        return droneHeight;
    }

    public void setDroneHeight(DroneHeightModel droneHeight) {
        this.droneHeight = droneHeight;
    }

    public List<DroneCameraModel> getCameras() {
        return cameras;
    }

    public DroneCameraModel getCamera(int index) {
        for (DroneCameraModel item : cameras) {
            if (item.getCameraIndex() == index) {
                return item;
            }
        }
        return null;
    }

    public void changeCamera(int index, DroneCameraModel model) {
        for (DroneCameraModel item : cameras) {
            if (item.getCameraIndex() == index) {
                cameras.remove(item);
                break;
            }
        }
        cameras.add(model);
    }

    public void switchCamera(int fromIndex, int toIndex) {
        for (DroneCameraModel item : cameras) {
            if (item.getCameraIndex() == fromIndex) {
                item.setCameraIndex(toIndex);
            } else if (item.getCameraIndex() == toIndex) {
                item.setCameraIndex(fromIndex);
            }
        }
    }

    public void deleteCamera(int index) {
        for (DroneCameraModel item : cameras) {
            if (item.getCameraIndex() == index) {
                cameras.remove(item);
                break;
            }
        }
    }

    public boolean hasEP800Camera() {
        for (DroneCameraModel item : cameras) {
            if (item.getPayloadCameraType() == PayloadCameraType.EP800.value()) {
                return true;
            }
        }
        return false;
    }

    public boolean supportPreciseShot() {
        for (DroneCameraModel item : cameras) {
            if (CameraUtil.isSupportPreciseShot(CameraType.find(item.getCameraType()))){
                return true;
            }
        }
        return false;
    }

    @Override
    public DroneInfoModel clone() {
        DroneInfoModel model = null;
        try {
            model = (DroneInfoModel) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        model.cameras = CollectionUtil.transform(cameras, DroneCameraModel::clone);
        if (droneHeight != null) {
            model.droneHeight = droneHeight.clone();
        }
        return model;
    }


}
