package com.dji.wpmzsdk.common.utils.kml.mission;

/**
 * @author feel.feng
 * @time 2023/06/30 2:16 下午
 * @description:
 */
public enum RTKReferenceStationSource {
    /**
     * NONE
     */
    NONE (0),
    /**
     * QX Network RTK
     */
    QX_NETWORK_SERVICE (1),
    /**
     * RTK is using the D-RTK ground system as the reference station.
     */
    BASE_STATION (2),
    /**
     *  DPS is dji network service as the reference station, but not open to users.
     */
    DPS (3),
    /**
     * RTK is using third-party network service as the reference station.  The network service should use NTRIP(Networked Transport of RTCM via  Internet Protocol).
     */
    CUSTOM_NETWORK_SERVICE (4),
    /**
     * RTK is using dji new service network rtk as the reference station. The network service should use NTRIP.
     */
    NTRIP_NETWORK_SERVICE (5),
    /**
     * RTK is using from dock base.
     */
    DOCK_BASE (6),
    /**
     * reserve rtk service 2.
     */
    RSV_RTK_SERVICE2 (7),
    /**
     * reserve rtk service 3.
     */
    RSV_RTK_SERVICE3 (8),
    /**
     * Unknown reference station source.
     */
    UNKNOWN (0xFFFF);

    private int value;

    private static final RTKReferenceStationSource[] allValues = values();

    RTKReferenceStationSource(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public boolean equals(int b) {
        return value == b;
    }

    public static RTKReferenceStationSource find(int value) {
        RTKReferenceStationSource result = null;
        for (int i = 0; i < allValues.length; i++) {
            if (allValues[i].equals(value)) {
                result = allValues[i];
                break;
            }
        }

        if(null == result){
            result = RTKReferenceStationSource.UNKNOWN;
            result.value = value;
        }

        return result;
    }
}
