package com.dji.wpmzsdk.common.utils.kml.model;
/*
 * Copyright (c) 2014, DJI All Rights Reserved.
 */

/**
 * <p>Created by luca on 2017/1/23.</p>
 */

public class Location3D extends Location2D{

    /**
     * The location height
     */
    private float altitude;

    public Location3D(double latitude, double longitude, float altitude) {
        super(latitude, longitude);
        this.altitude = altitude;
    }

    public Location3D(double latitude, double longitude) {
        super(latitude, longitude);
    }

    public float getAltitude() {
        return altitude;
    }

    public void setAltitude(float altitude) {
        this.altitude = altitude;
    }

    @Override
    public String toString() {
        return super.toString()+" Location3D{" +
            "altitude=" + altitude +
            '}';
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj)
            && (obj instanceof Location3D)
            && Float.floatToIntBits(this.altitude) == Float.floatToIntBits(((Location3D)obj).altitude);
    }

    public boolean isChanged(double lat, double lng, float alt) {
        return Math.abs(latitude - lat) >= GPS_CHANGED || Math.abs(longitude - lng) >= GPS_CHANGED || Math.abs(altitude - alt) >= 0.1;
    }
}
