package com.dji.wpmzsdk.common.utils.kml.model;

import android.os.Parcel;
import android.os.Parcelable;

import org.json.JSONObject;

import java.util.Objects;

/**
 * @author feel.feng
 * @time 2023/06/30 2:49 下午
 * @description:
 */
public class LocationCoordinate3D  {
    /**
     * 纬度
     */
    Double latitude = 0d;
    /**
     * 经度
     */
    Double longitude = 0d;
    /**
     * 高度
     */
    Double altitude = 0d;
    public LocationCoordinate3D(){

    }

    public LocationCoordinate3D(Double latitude, Double longitude, Double altitude){

        if (latitude != null) {
            this.latitude = latitude;
        }

        if (longitude != null) {
            this.longitude = longitude;
        }

        if (altitude != null) {
            this.altitude = altitude;
        }
    }

    public static LocationCoordinate3D fromJson(String jsonString){
        LocationCoordinate3D tmpValueResult_ = new LocationCoordinate3D();
        JSONObject jsonObj = null;
        try{
            jsonObj = new JSONObject(jsonString);
            tmpValueResult_.latitude = jsonObj.getDouble("latitude");
            tmpValueResult_.longitude = jsonObj.getDouble("longitude");
            tmpValueResult_.altitude = jsonObj.getDouble("altitude");
        }
        catch (Exception e){
            tmpValueResult_ = null;
        }
        return tmpValueResult_;
    }

    public JSONObject toJson(){
        JSONObject json = null;

        try{
            json = new JSONObject();
            if(null != latitude) {
                json.put("latitude", latitude);
            }
            if(null != longitude) {
                json.put("longitude", longitude);
            }
            if(null != altitude) {
                json.put("altitude", altitude);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }

        return json;
    }




    public Double getLatitude(){
        return latitude;
    }

    public void setLatitude(Double latitude){
        this.latitude = latitude;
    }

    public Double getLongitude(){
        return longitude;
    }

    public void setLongitude(Double longitude){
        this.longitude = longitude;
    }

    public Double getAltitude(){
        return altitude;
    }

    public void setAltitude(Double altitude){
        this.altitude = altitude;
    }


    @Override
    public String toString() {
        JSONObject json = toJson();
        return json != null ? json.toString() : "";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || (!(o instanceof LocationCoordinate3D))) return false;
        LocationCoordinate3D that = (LocationCoordinate3D) o;
        return Objects.equals(latitude, that.latitude) &&
                Objects.equals(longitude, that.longitude) &&
                Objects.equals(altitude, that.altitude) ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(latitude,longitude,altitude);
    }

    public int describeContents() {
        return 0;
    }



    protected LocationCoordinate3D(Parcel in) {
        this.latitude = in.readDouble();
        this.longitude = in.readDouble();
        this.altitude = in.readDouble();
    }



}