package com.dji.wpmzsdk.common.utils.kml.model;
/*
 *   WWWWWW||WWWWWW
 *    W W W||W W W
 *         ||
 *       ( OO )__________
 *        /  |           \
 *       /o o|    DJI     \
 *       \___/||_||__||_|| **
 *            || ||  || ||
 *           _||_|| _||_||
 *          (__|__|(__|__|
 *
 * Copyright (c) 2017, DJI All Rights Reserved.
 */

/**
 * <p>Description:</p>
 *
 * @author create at 2018/12/21 18:42 by davis.qiao for dji-pilot
 * @version v1.0
 */

public class Mapping3DWaylineModel extends Mapping2DWaylineModel {

    private float inclineSpeed;
    private int gimbalPitch;
    private int inclineOverlapH;
    private int inclineOverlapW;

    public float getInclineSpeed() {
        return inclineSpeed;
    }

    public void setInclineSpeed(float inclineSpeed) {
        this.inclineSpeed = inclineSpeed;
    }

    public int getGimbalPitch() {
        return gimbalPitch;
    }

    public void setGimbalPitch(int gimbalPitch) {
        this.gimbalPitch = gimbalPitch;
    }

    public int getInclineOverlapH() {
        return inclineOverlapH;
    }

    public void setInclineOverlapH(int inclineOverlapH) {
        this.inclineOverlapH = inclineOverlapH;
    }

    public int getInclineOverlapW() {
        return inclineOverlapW;
    }

    public void setInclineOverlapW(int inclineOverlapW) {
        this.inclineOverlapW = inclineOverlapW;
    }


    @Override
    public Mapping3DWaylineModel clone() {
        return (Mapping3DWaylineModel) super.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;

        Mapping3DWaylineModel that = (Mapping3DWaylineModel) o;

        if (Float.compare(that.inclineSpeed, inclineSpeed) != 0) return false;
        if (gimbalPitch != that.gimbalPitch) return false;
        if (inclineOverlapH != that.inclineOverlapH) return false;
        return inclineOverlapW == that.inclineOverlapW;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (inclineSpeed != +0.0f ? Float.floatToIntBits(inclineSpeed) : 0);
        result = 31 * result + gimbalPitch;
        result = 31 * result + inclineOverlapH;
        result = 31 * result + inclineOverlapW;
        return result;
    }


    public Mapping3DWaylineModel() {
    }


}
