package com.dji.wpmzsdk.common.utils.kml.model;

/**
 * <p>Description:</p>
 *
 * @author create at 2019/1/3 21:30 by davis.qiao for dji-pilot
 * @version v1.0
 */

public enum MappingCameraType {
    // P4 series
    P4("Phantom 4", 3.6f, 6.20f, 4.65f, 2322.6f, 0, 0),
    P4P("Phantom 4 Pro", 8.8f, 13.13f, 8.76f, 3650.0f, 0, 0),
    P4R("Phantom 4 RTK", 8.8f, 13.13f, 8.76f, 3650.0f, 0, 0),
    P4PV2("Phantom 4 Pro V2.0", 8.8f, 13.13f, 8.76f, 3650.0f, 0, 0),
    P4A("Phantom 4 Advanced", 8.8f, 13.13f, 8.76f, 3650.0f, 0, 0),
    // PSDK Camera: Share 102S
    SHARE_102S("PSDK 102S", 25f, 23.5f, 15.6f, 0f, 6000, 4000),
    // X7
    X7_24MM("X7 ( 24mm )", 24.0f, 23.5f, 15.7f, 0f, 6016, 4008),
    X7_35MM("X7 ( 35mm )", 35.0f, 23.5f, 15.7f, 0f, 6016, 4008),
    // M2 series
    WM245_ZOOM("Mavic 2 Enterprise ZOOM", 4.4f, 5.57f, 4.17f, 0f, 4000, 3000),
    WM246("Mavic 2 Enterprise DUAL", 4.49f, 5.57f, 4.17f, 0f, 4056, 3040),
    // M300
    EP800_LIDAR("Zenmuse L1 LiDAR Mapping", 8.8f, 13.13f, 8.76f, 0f, 5472, 3648),
    EP800_VISUAL("Zenmuse L1 Photogrammetry", 8.8f, 13.13f, 8.76f, 0f, 5472, 3648),

    GD610("Zenmuse H20 WIDE", 4.5f, 6.29f, 4.71f, 0f, 4056, 3040),
    GD610T_WIDE("Zenmuse H20T WIDE", 4.5f, 6.29f, 4.71f, 0f, 4056, 3040),
    GD610_IR("Zenmuse H20T IR", 13.5f, 7.68f, 6.14f, 0f, 640, 512),
    GD610_WIDE_IR("Zenmuse H20T WIDE IR", 13.5f, 7.68f, 6.14f, 0f, 640, 512),

    GD612_WIDE("Zenmuse H20N WIDE", 4.46f, 5.76f, 3.24f, 0f, 1932, 1092),
    GD612_IR("Zenmuse H20N IR", 12f, 7.68f, 6.14f, 0f, 640, 512),
    GD612_WIDE_IR("Zenmuse H20N WIDE IR", 12f, 7.68f, 6.14f, 0f, 640, 512),

    EP600_24MM("Zenmuse P1 ( 24mm )", 24.0f, 36.0f, 24.0f, 0f, 8192, 5460),
    EP600_35MM("Zenmuse P1 ( 35mm )", 35.0f, 36.0f, 24.0f, 0f, 8192, 5460),
    EP600_50MM("Zenmuse P1 ( 50mm )", 50.0f, 36.0f, 24.0f, 0f, 8192, 5460),

    PM320("M30 WIDE", 4.5f, 6.4f, 4.8f, 0, 4000, 3000),
    PM320T_WIDE("M30T WIDE", 4.5f, 6.4f, 4.8f, 0, 4000, 3000),
    PM320_IR("M30T IR", 9.1f, 7.68f, 6.14f, 0, 640, 512),
    PM320_WIDE_IR("M30T WIDE IR", 9.1f, 7.68f, 6.14f, 0, 640, 512),

    WM265_WIDE("M3E WIDE", 12.29f, 17.42f, 13.06f, 0f, 5280, 3956),

    WM265_T_WIDE("M3T WIDE", 4.55f, 6.4f, 4.8f, 0f, 4000, 3000),
    WM265_IR("M3T IR", 9.1f, 7.68f, 6.14f, 0f, 640, 512),
    WM265_WIDE_IR("M3T WIDE IR", 9.1f, 7.68f, 6.14f, 0f, 640, 512),

    WM265_M_WIDE("M3M WIDE", 12.29f, 17.42f, 13.06f, 0f, 5280, 3956),
    WM265_M_NARROWBAND("M3M R G RE NIR", 4.34f, 5.18f, 3.89f, 0f, 2592, 1944),
    WM265_M_WIDE_NARROWBAND("M3M WIDE R G RE NIR", 4.34f, 5.18f, 3.89f, 0f, 2592, 1944),

    //自定义相机，取用MappingCameraModel的值
    OTHER("Custom Camera", 0f, 0f, 0f, 0f, 0, 0),
    //空相机
    NULL("", 0f, 0f, 0f, 0f, 0, 0);
    // M200(AndUtil.getResString(R.string.mapping_camera_type_m200), 10f, 11.33f, 8.5f, 3650.0f),

    private final String nameStr;

    private final float focalLength;

    private final float sensorW;

    private final float sensorH;

    /**
     * P4 系列有 Gsdbase， GSD 值根据此值计算
     */
    private final float gsdBase;

    /**
     * 除P4系列相机外，GSD 根据下列值计算
     */
    private final int imageWidth;

    private final int imageHeight;

    MappingCameraType(String nameStr, float focalLength, float sensorW, float sensorH, float gsdBase,
                      int imageWidth, int imageHeight) {
        this.nameStr = nameStr;
        this.focalLength = focalLength;
        this.sensorW = sensorW;
        this.sensorH = sensorH;
        this.gsdBase = gsdBase;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
    }

    // 固定值，用来去对比，新的相机不能重名，type和camera转换
    public String getNameStr() {
        return nameStr;
    }

    public float getFocalLength() {
        return focalLength;
    }

    public float getSensorW() {
        return sensorW;
    }

    public float getSensorH() {
        return sensorH;
    }

    public float getGsdBase() {
        return gsdBase;
    }

    public int getImageWidth() {
        return imageWidth;
    }

    public int getImageHeight() {
        return imageHeight;
    }

    public static boolean contains(String name) {
        for (MappingCameraType type : values()) {
            if (type.nameStr.equals(name)) {
                return true;
            }
        }
        return false;
    }

    public static MappingCameraType find(String name) {
        for (MappingCameraType type : values()) {
            if (type.nameStr.equals(name)) {
                return type;
            }
        }
        return OTHER;
    }

    public static boolean isP4Series(MappingCameraType type) {
        return type == P4 || type == P4P || type == P4A || type == P4PV2 || type == P4R;
    }

    public static boolean isEP600(MappingCameraType type) {
        return type == EP600_35MM || type == EP600_24MM || type == EP600_50MM;
    }

    public static boolean isEP800(MappingCameraType type) {
        return type == EP800_VISUAL || type == EP800_LIDAR;
    }

    /**
     * 支持负载设置 EP800 && EP600
     */
    public static boolean isSupportAdvanceSetting(MappingCameraType type) {
        return isEP600(type) || isEP800(type);
    }

    /**
     * 支持绝对高度： EP600 EP800 P4R GD610, SHARE 102S, PM320
     */
    public static boolean isSupportAbsAlt(MappingCameraType type) {
        return isEP600(type) || type == P4R || isEP800(type) || isGD610Series(type) || type == SHARE_102S || isPM320Series(type) || isWM265Series(type);
    }

    public static boolean isGD610Series(MappingCameraType type) {
        return type == GD610 || type == GD610T_WIDE || type == GD610_IR || type == GD610_WIDE_IR || type == GD612_WIDE || type == GD612_IR || type == GD612_WIDE_IR;
    }

    public static boolean isPM320Series(MappingCameraType type) {
        return type == PM320 || type == PM320T_WIDE || type == PM320_IR || type == PM320_WIDE_IR;
    }

    public static boolean isPM430OrPM431Series(MappingCameraType type) {
        return type == SHARE_102S || type == X7_24MM || type == X7_35MM
                || isEP800(type) || isEP600(type) || isGD610Series(type);
    }

    public static boolean isWM265Series(MappingCameraType type) {
        return type == WM265_WIDE
                || type == WM265_T_WIDE
                || type == WM265_IR
                || type == WM265_WIDE_IR
                || type == WM265_M_WIDE
                || type == WM265_M_NARROWBAND
                || type == WM265_M_WIDE_NARROWBAND;
    }

    /**
     * 是否支持智能摆动拍摄 E
     * @param type
     * @return
     */
    public static boolean isSupportSmartObliquePitch(MappingCameraType type) {
        return type == WM265_WIDE || type == WM265_M_WIDE;
    }

    public static String getDroneDesc(MappingCameraType type) {
        if (isSupportSmartObliquePitch(type)) {
            return "wm265";
        }
        if (isEP600(type)) {
            return "ep600";
        }
        return "";
    }

    public static boolean isSupportSafeTakeoff(MappingCameraType type) {
        return isWM265Series(type) || isPM320Series(type) || isPM430OrPM431Series(type);
    }

    /**
     * 支持仿地飞行 P4系列 和 Mavic系列不支持 （断点问题暂没有办法处理：这俩机型由于只能拿到断点的相对高）
     */
    public static boolean isSupportDsm(MappingCameraType type) {
        return !isP4Series(type) && type != WM245_ZOOM && type != WM246;
    }

    /**
     * V3 V4 不再支持的设备
     */
    public static boolean isUnsupportedDevice(MappingCameraType type) {
        return isP4Series(type) || type == X7_24MM || type == X7_35MM || type == WM245_ZOOM || type == WM246;
    }

    public static boolean isTerraMappingCamera(MappingCameraType cameraType) {
        return cameraType == MappingCameraType.PM320 || cameraType == MappingCameraType.PM320T_WIDE || cameraType == MappingCameraType.PM320_IR
                || cameraType == MappingCameraType.GD610 || cameraType == MappingCameraType.GD610T_WIDE || cameraType == MappingCameraType.GD610_IR
                || cameraType == MappingCameraType.GD612_WIDE || cameraType == MappingCameraType.GD612_IR
                || cameraType == MappingCameraType.WM265_WIDE || cameraType == MappingCameraType.WM265_T_WIDE || cameraType == MappingCameraType.WM265_IR
                || isTerraMappingWideIrCamera(cameraType);
    }

    public static boolean isTerraMappingWideIrCamera(MappingCameraType cameraType) {
        return cameraType == MappingCameraType.PM320_WIDE_IR || cameraType == MappingCameraType.GD610_WIDE_IR || cameraType == MappingCameraType.GD612_WIDE_IR || cameraType == MappingCameraType.WM265_WIDE_IR;
    }
}
