package com.dji.wpmzsdk.common.utils.kml.model;
/*
 *   WWWWWW||WWWWWW
 *    W W W||W W W
 *         ||
 *       ( OO )__________
 *        /  |           \
 *       /o o|    DJI     \
 *       \___/||_||__||_|| **
 *            || ||  || ||
 *           _||_|| _||_||
 *          (__|__|(__|__|
 *
 * Copyright (c) 2017, DJI All Rights Reserved.
 */



import com.dji.wpmzsdk.common.utils.kml.CollectionUtil;
import com.dji.wpmzsdk.common.utils.kml.mission.MissionInfoModel;
import com.dji.wpmzsdk.common.utils.kml.transfrom.MissionTransformData;

import java.util.List;

/**
 * <p>Description:</p>
 *
 * @author create at 2018/12/21 16:10 by davis.qiao for dji-pilot
 * @version v1.0
 */

public class MappingMissionModel implements Cloneable {

    private Long id;
    private MissionInfoModel missionInfo;
    private Mapping2DWaylineModel mappingWayline;
    private List<EdgePointModel> edgePoints;
    private MissionTransformData transformData;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MissionInfoModel getMissionInfo() {
        return missionInfo;
    }

    public void setMissionInfo(MissionInfoModel missionInfo) {
        this.missionInfo = missionInfo;
    }

    public Mapping2DWaylineModel getMappingWayline() {
        return mappingWayline;
    }

    public void setMappingWayline(Mapping2DWaylineModel mappingWayline) {
        this.mappingWayline = mappingWayline;
    }

    public List<EdgePointModel> getEdgePoints() {
        return edgePoints;
    }

    public void setEdgePoints(List<EdgePointModel> edgePoints) {
        this.edgePoints = edgePoints;
    }

    public MissionTransformData getTransformData() {
        return transformData;
    }

    public void setTransformData(MissionTransformData transformData) {
        this.transformData = transformData;
    }

    public MappingCameraType getCameraType() {
        String name = mappingWayline.getCamera().getName();
        for (MappingCameraType type : MappingCameraType.values()) {
            if (type.getNameStr().equals(name) && type != MappingCameraType.OTHER) {
                return type;
            }
        }
        return MappingCameraType.OTHER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MappingMissionModel that = (MappingMissionModel) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (missionInfo != null ? !missionInfo.equals(that.missionInfo) : that.missionInfo != null) return false;
        if (mappingWayline != null ? !mappingWayline.equals(that.mappingWayline) : that.mappingWayline != null) return false;
        return edgePoints != null ? edgePoints.equals(that.edgePoints) : that.edgePoints == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (missionInfo != null ? missionInfo.hashCode() : 0);
        result = 31 * result + (mappingWayline != null ? mappingWayline.hashCode() : 0);
        result = 31 * result + (edgePoints != null ? edgePoints.hashCode() : 0);
        return result;
    }

    @Override
    public MappingMissionModel clone() {
        MappingMissionModel model;
        try {
            model = (MappingMissionModel) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        if (mappingWayline != null) {
            model.setMappingWayline(mappingWayline.clone());
        }
        if (missionInfo != null) {
            model.setMissionInfo(missionInfo.clone());
        }
        model.setEdgePoints(CollectionUtil.transform(edgePoints, EdgePointModel::clone));
        return model;
    }

    public MappingMissionModel() {
    }

    @Override
    public String toString() {
        return "MappingMissionModel{" +
                "id=" + id +
                ", missionInfo=" + missionInfo +
                ", mappingWayline=" + mappingWayline +
                ", edgePoints=" + edgePoints +
                ", transformData=" + transformData +
                '}';
    }
}
