package com.dji.wpmzsdk.common.utils.kml.model

import com.dji.wpmzsdk.common.utils.kml.data.MissionType
import com.dji.wpmzsdk.common.utils.kml.mission.MissionInfoModel
import com.dji.wpmzsdk.common.utils.kml.mission.RTKReferenceStationSource


/**
 * Description :
 *
 * @filename : MissionInfoModelGreenDao
 * @author : devin.xu
 * @time : 2022/12/1
 *
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
class MissionInfoModelGreenDao {

    var id: Long = 0
    var uuid: String = ""
    var name: String = ""
    var createTime: Long = 0
    var updateTime: Long = 0
    var type: MissionType? = null
    var diagram: String? = null
    var latitude = 0.0
    var longitude = 0.0
    var locationDesc: String? = null
    var distance = 0f
    var duration = 0f
    var collected = false
    var rtkStation: RTKReferenceStationSource = RTKReferenceStationSource.NONE
    var extInfo: MissionInfoExtModel = MissionInfoExtModel()

    fun getMissionInfoModel(): MissionInfoModel {
        val infoModel = MissionInfoModel()
        infoModel.id = id
        infoModel.uuid = uuid
        infoModel.name = name
        infoModel.createTime = createTime
        infoModel.updateTime = updateTime
        infoModel.type = type
        infoModel.diagram = diagram
        infoModel.latitude = latitude
        infoModel.longitude = longitude
        infoModel.locationDesc = locationDesc
        infoModel.distance = distance
        infoModel.duration = duration
        infoModel.isCollected = collected
        infoModel.rtkStation = rtkStation
        infoModel.extInfo = extInfo
        return infoModel
    }
}