package com.dji.wpmzsdk.common.utils.kml.model


import com.dji.wpmzsdk.common.utils.kml.transfrom.MissionTransformData
import com.dji.wpmzsdk.common.utils.kml.transfrom.WaylineDroneTypeTransform
import com.dji.wpmzsdk.common.utils.kml.transfrom.WaylinePayloadInfoTransform
import dji.sdk.wpmz.value.mission.WaylineAircraftConvertInvalidValueInfo
import dji.sdk.wpmz.value.mission.WaylineDroneInfo
import dji.sdk.wpmz.value.mission.WaylinePayloadInfo
import dji.sdk.wpmz.value.mission.WaylineTemplate
import java.io.File

/**
 * Description :
 *
 * @filename : MissionWaypointDroneTypeUtil
 * @author : devin.xu
 * @time : 2022/12/21
 *
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
//class MissionWaypointDroneTypeUtil {
//
//    var droneTypeTransform = WaylineDroneTypeTransform()
//    var cameraTypeTransform = WaylinePayloadInfoTransform()
//    var waypointMissionTransform = WaypointTemplateTransform()
//
//    fun switchTo(model: WaypointMissionModel, droneType: WaypointDroneType): ConvertInfo {
//        val sourceDroneType = model.wayline.droneInfo.droneType
//        val sourceDroneCameras = model.wayline.droneInfo.cameras
//        val destDroneInfo = getDestDroneInfo(droneType, getDestCameras(sourceDroneType, sourceDroneCameras, droneType))
//        return switchTo(model, destDroneInfo)
//    }
//
//    fun switchTo(model: WaypointMissionModel, destDroneType: WaypointDroneType, destCameras: List<DroneCameraModel>): ConvertInfo {
//        val destDroneInfo = getDestDroneInfo(destDroneType, destCameras)
//        return switchTo(model, destDroneInfo)
//    }
//
//    private fun switchTo(model: WaypointMissionModel, destDroneInfo: DestDroneInfo): ConvertInfo {
//        val missionTransformData = waypointMissionTransform.transFrom(model)
//        val convertInfo = WPMZ.getDroneTypeChangeContent(missionTransformData.missionConfig, missionTransformData.templates, destDroneInfo.droneInfo, destDroneInfo.payloadInfos)
//
//        val convertTransformData = MissionTransformData()
//        convertTransformData.missionConfig = convertInfo.missionConfig
//        convertTransformData.templates = convertInfo.templates
//        val convertModel = waypointMissionTransform.transTo(convertTransformData)
//
//        val preciseImagePath = getPreciseImagePath(model)
//        convertModel.waypoints.forEach {
//            it.actions.forEach { action ->
//                if (action.isPreciseShotAction && action.preciseShotInfo.cacheFileName != null) {
//                    val file = File(preciseImagePath, action.preciseShotInfo.cacheFileName)
//                    if (file.exists()) {
//                        action.preciseShotInfo.cacheFilePath = preciseImagePath
//                    }
//                }
//            }
//        }
//        val invalidInfo = translateInvalidInfo(convertInfo.invalidList, convertInfo.templates[0])
//        return ConvertInfo(convertModel.wayline, convertModel.waypoints, invalidInfo)
//    }
//
//    private fun getPreciseImagePath(mission: WaypointMissionModel): String {
//        for (waypointModel in mission.waypoints) {
//            val actions = waypointModel.actions
//            if (actions != null && actions.size > 0) {
//                for (actionModel in actions) {
//                    val preciseShotInfo = actionModel.preciseShotInfo
//                    if (preciseShotInfo != null && preciseShotInfo.cacheFilePath != null) {
//                        return preciseShotInfo.cacheFilePath
//                    }
//                }
//            }
//        }
//        return ""
//    }
//
//    fun getDestDroneInfo(sourceDroneType: WaypointDroneType, destDroneType: WaypointDroneType): DestDroneInfo {
//        return getDestDroneInfo(destDroneType, getDestCameras(sourceDroneType, listOf(), destDroneType))
//    }
//
//    private fun getDestCameras(sourceType: WaypointDroneType, sourceCameras: List<DroneCameraModel>, destType: WaypointDroneType): List<DroneCameraModel> {
//        val destCameras = mutableListOf<DroneCameraModel>()
//        if (destType == WaypointDroneType.PM430) {
//            destCameras.addAll(getPM430DestCamera(sourceType, sourceCameras))
//        } else if (destType == WaypointDroneType.PM431) {
//            destCameras.addAll(getPM431DestCamera(sourceType, sourceCameras))
//        } else {
//            destCameras.add(getCertainDestCamera(destType))
//        }
//        return destCameras
//    }
//
//    private fun getPM430DestCamera(sourceType: WaypointDroneType, sourceCameras: List<DroneCameraModel>): List<DroneCameraModel> {
//        val destCameras = mutableListOf<DroneCameraModel>()
//        if (sourceType == WaypointDroneType.PM431) {
//            destCameras.addAll(sourceCameras)
//        } else if (sourceType == WaypointDroneType.PM320_T_RTK || sourceType == WaypointDroneType.WM265_T) {
//            destCameras.add(getCameraModel(CameraType.DJICameraTypeGD610TripleLight))
//        } else {
//            destCameras.add(getCameraModel(CameraType.DJICameraTypeGD610DualLight))
//        }
//        return destCameras
//    }
//
//    private fun getPM431DestCamera(sourceType: WaypointDroneType, sourceCameras: List<DroneCameraModel>): List<DroneCameraModel> {
//        val destCameras = mutableListOf<DroneCameraModel>()
//        if (sourceType == WaypointDroneType.PM430) {
//            destCameras.addAll(sourceCameras.map {
//                if (it.cameraType == CameraType.ZENMUSE_X30.value()
//                    || it.cameraType == CameraType.ZENMUSE_XT2.value()
//                    || it.cameraType == CameraType.ZENMUSE_XTS.value()) {
//                    getCameraModel(CameraType.DJICameraTypeGD610DualLight, it.cameraIndex)
//                } else {
//                    it
//                }
//            })
//        } else if (sourceType == WaypointDroneType.PM320_T_RTK || sourceType == WaypointDroneType.WM265_T) {
//            destCameras.add(getCameraModel(CameraType.DJICameraTypeGD610TripleLight))
//        } else {
//            destCameras.add(getCameraModel(CameraType.DJICameraTypeGD610DualLight))
//        }
//        return destCameras
//    }
//
//    private fun getCertainDestCamera(destType: WaypointDroneType): DroneCameraModel {
//        return if (destType == WaypointDroneType.PM320) {
//            getCameraModel(CameraType.DJICameraTypePM320DualLight)
//
//        } else if (destType == WaypointDroneType.PM320_T_RTK) {
//            getCameraModel(CameraType.DJICameraTypePM320TripleLight)
//
//        } else if (destType == WaypointDroneType.WM265_E) {
//            getCameraModel(CameraType.WM265_E)
//        } else if (destType == WaypointDroneType.WM265_T) {
//            getCameraModel(CameraType.WM265_T)
//        } else if (destType == WaypointDroneType.WM265_M) {
//            getCameraModel(CameraType.WM265_M)
//        } else {
//            getCameraModel(CameraType.UNKNOWN)
//        }
//    }
//
//    private fun getCameraModel(type: CameraType, index: Int = 0): DroneCameraModel {
//        return DroneCameraModel().apply {
//            cameraType = type.value()
//            cameraIndex = index
//        }
//    }
//
//    private fun getDestDroneInfo(droneType: WaypointDroneType, cameraModel: List<DroneCameraModel>): DestDroneInfo {
//        val droneInfo = droneTypeTransform.transFrom(droneType)
//        val cameraList = cameraModel.map { cameraTypeTransform.transFrom(it) }
//
//        return DestDroneInfo(droneInfo, cameraList)
//    }
//
//    private fun translateInvalidInfo(infoList: List<WaylineAircraftConvertInvalidValueInfo>, template: WaylineTemplate): List<List<MissionFaultSegment>> {
//        return infoList.map { parseSeg(it.tag, it.value, template) }
//    }
//
//    data class DestDroneInfo(
//        val droneInfo: WaylineDroneInfo,
//        val payloadInfos: List<WaylinePayloadInfo> = listOf()
//    )
//
//    data class ConvertInfo(val waylineModel: WaylineModel,
//                           val waypointModels: List<WaypointModel>,
//                           val invalidInfos: List<List<MissionFaultSegment>>)
//
//}