package com.dji.wpmzsdk.common.utils.kml.model;

import dji.sdk.wpmz.jni.JNIProguardKeepTag;

public enum PayloadCameraType implements JNIProguardKeepTag {
    /**
     *  EP800
     */
    EP800 (1),
    /**
     *  EP600
     */
    EP600 (2),
    /**
     * Unknown
     */
    UNKNOWN (0xFFFF);

    private int value;

    private static final PayloadCameraType[] allValues = values();

    PayloadCameraType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public boolean equals(int b) {
        return value == b;
    }

    public static PayloadCameraType find(int value) {
        PayloadCameraType result = null;
        for (int i = 0; i < allValues.length; i++) {
            if (allValues[i].equals(value)) {
                result = allValues[i];
                break;
            }
        }

        if(null == result){
            result = PayloadCameraType.UNKNOWN;
            result.value = value;
        }

        return result;
    }
}