package com.dji.wpmzsdk.common.utils.kml.model;

/**
 * Description :
 * 航线旋转模式
 * @author : devin.xu
 * @time : 2019/04/29
 *
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public enum PointTurnMode {

    /**
     *  顺时针
     */
    CLOCKWISE(0),

    /**
     *  逆时针
     */
    COUNTER_CLOCKWISE(1),

    /**
     * 最小旋转角度
     */
    AUTO(2);

    private int value;

    PointTurnMode(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public boolean _equals(int value) {
        return this.value==value;
    }

    public static PointTurnMode find(int value) {
        PointTurnMode result = CLOCKWISE;
        for (int i = 0; i < values().length; i++) {
            if (values()[i]._equals(value)) {
                result = values()[i];
                break;
            }
        }
        return result;
    }
}
