package com.dji.wpmzsdk.common.utils.kml.model;

import dji.sdk.wpmz.jni.JNIProguardKeepTag;

/**
 * @author feel.feng
 * @time 2023/06/30 3:13 下午
 * @description:
 */
public enum ScanMode implements JNIProguardKeepTag {
    /**
     *  非重复扫描模式
     */
    NON_REPEAT (0),
    /**
     *  重复扫描模式
     */
    REPEAT (1),
    /**
     * Unknow
     */
    UNKNOWN (0xFFFF);

    private int value;

    private static final ScanMode[] allValues = values();

    ScanMode(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public boolean equals(int b) {
        return value == b;
    }

    public static ScanMode find(int value) {
        ScanMode result = null;
        for (int i = 0; i < allValues.length; i++) {
            if (allValues[i].equals(value)) {
                result = allValues[i];
                break;
            }
        }

        if(null == result){
            result = ScanMode.UNKNOWN;
            result.value = value;
        }

        return result;
    }
}
