package com.dji.wpmzsdk.common.utils.kml.model;
/*
 *   WWWWWW||WWWWWW
 *    W W W||W W W
 *         ||
 *       ( OO )__________
 *        /  |           \
 *       /o o|    DJI     \
 *       \___/||_||__||_|| **
 *            || ||  || ||
 *           _||_|| _||_||
 *          (__|__|(__|__|
 *
 * Copyright (c) 2017, DJI All Rights Reserved.
 */


import com.dji.wpmzsdk.common.utils.kml.CollectionUtil;
import com.dji.wpmzsdk.common.utils.kml.mission.MissionInfoModel;
import com.dji.wpmzsdk.common.utils.kml.transfrom.MissionTransformData;

import java.util.List;


/**
 * @author create at 2020/06/10 by otto.ouyang for dji-pilot
 */

public class StripMissionModel implements Cloneable {

    private Long id;
    private MissionInfoModel missionInfo;
    private StripWaylineModel stripWayline;
    private List<StripEdgePointModel> edgePoints;
    private MissionTransformData transformData;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MissionInfoModel getMissionInfo() {
        return missionInfo;
    }

    public void setMissionInfo(MissionInfoModel missionInfo) {
        this.missionInfo = missionInfo;
    }

    public StripWaylineModel getStripWayline() {
        return stripWayline;
    }

    public void setStripWayline(StripWaylineModel stripWayline) {
        this.stripWayline = stripWayline;
    }

    public List<StripEdgePointModel> getEdgePoints() {
        return edgePoints;
    }

    public void setEdgePoints(List<StripEdgePointModel> edgePoints) {
        this.edgePoints = edgePoints;
    }

    public MissionTransformData getTransformData() {
        return transformData;
    }

    public void setTransformData(MissionTransformData transformData) {
        this.transformData = transformData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        StripMissionModel that = (StripMissionModel) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (missionInfo != null ? !missionInfo.equals(that.missionInfo) : that.missionInfo != null) return false;
        if (stripWayline != null ? !stripWayline.equals(that.stripWayline) : that.stripWayline != null) return false;
        return edgePoints != null ? edgePoints.equals(that.edgePoints) : that.edgePoints == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (missionInfo != null ? missionInfo.hashCode() : 0);
        result = 31 * result + (stripWayline != null ? stripWayline.hashCode() : 0);
        result = 31 * result + (edgePoints != null ? edgePoints.hashCode() : 0);
        return result;
    }

    @Override
    public StripMissionModel clone() {
        StripMissionModel model;
        try {
            model = (StripMissionModel) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        if (stripWayline != null) {
            model.setStripWayline(stripWayline.clone());
        }
        if (missionInfo != null) {
            model.setMissionInfo(missionInfo.clone());
        }
        model.setEdgePoints(CollectionUtil.transform(edgePoints, StripEdgePointModel::clone));
        return model;
    }

    public StripMissionModel() {
    }


}
