package com.dji.wpmzsdk.common.utils.kml.model;
/*
 *   WWWWWW||WWWWWW
 *    W W W||W W W
 *         ||
 *       ( OO )__________
 *        /  |           \
 *       /o o|    DJI     \
 *       \___/||_||__||_|| **
 *            || ||  || ||
 *           _||_|| _||_||
 *          (__|__|(__|__|
 *
 * Copyright (c) 2017, DJI All Rights Reserved.
 */



import com.dji.wpmzsdk.common.utils.kml.data.MissionType;
import com.dji.wpmzsdk.common.utils.kml.mission.WaypointMissionFinishedAction;

import java.util.List;


import dji.sdk.wpmz.value.mission.WaylineExitOnRCLostAction;

/**
 * @author create at 2020/06/10 by otto.ouyang for dji-pilot
 */

public class StripWaylineModel implements Cloneable {

    private Long id;
    private float altitude;
    private float wgs84Altitude;
    private float takeoffSpeed;
    private float speed;
    private int overlapH;
    private int overlapW;
    private WaypointMissionFinishedAction actionOnFinish;
    private MissionType type;
    private MappingCameraModel camera;
    private int photoMode;
    private float cutLength;
    private float leftExtend;
    private float rightExtend;
    private boolean hasCenterLine;
    private String startPoints;
    private int photoFormat;
    private boolean enableDewarping;
    private boolean enableSingleLine;
    // abs
    private int altitudeMode;
    private float relativeDistance;
    private int focusMode;

    /**
     * 航带规划模式：高效率、全覆盖
     */
    private int planMode;

    // lidar
    private int echoMode;
    private int sampleRate; // 这里存的是Index 要实际转化
    private int scanMode;
    private boolean needVariegation;
    private boolean enableCalibrate;
    private WaylineExitOnRCLostAction lostAction;
    private float stripSecureTakeoffHeight;

    private boolean stripEnableDsm;
    private float stripDsmAltitude;
    private List<String> stripDsmPath;
    private boolean stripRealtimeSurfaceFollow;
    // 倾斜爬升开关
    private boolean stripInclineClimbEnable;

    public String getStartPoints() {
        return startPoints;
    }

    public void setStartPoints(String startPoints) {
        this.startPoints = startPoints;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public float getAltitude() {
        return altitude;
    }

    public void setAltitude(float altitude) {
        this.altitude = altitude;
    }

    public float getSpeed() {
        return speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getTakeoffSpeed() {
        return takeoffSpeed;
    }

    public void setTakeoffSpeed(float takeoffSpeed) {
        this.takeoffSpeed = takeoffSpeed;
    }

    public int getOverlapH() {
        return overlapH;
    }

    public void setOverlapH(int overlapH) {
        this.overlapH = overlapH;
    }

    public int getOverlapW() {
        return this.overlapW;
    }

    public void setOverlapW(int overlapW) {
        this.overlapW = overlapW;
    }

    public WaypointMissionFinishedAction getActionOnFinish() {
        return actionOnFinish;
    }

    public void setActionOnFinish(WaypointMissionFinishedAction actionOnFinish) {
        this.actionOnFinish = actionOnFinish;
    }

    public MissionType getType() {
        return type;
    }

    public void setType(MissionType type) {
        this.type = type;
    }

    public MappingCameraModel getCamera() {
        return camera;
    }

    public void setCamera(MappingCameraModel camera) {
        this.camera = camera;
    }

    public int getPhotoMode() {
        return photoMode;
    }
    public void setPhotoMode(int photoMode) {
        this.photoMode = photoMode;
    }

    public float getCutLength() {
        return cutLength;
    }

    public void setCutLength(float cutLength) {
        this.cutLength = cutLength;
    }

    public float getLeftExtend() {
        return leftExtend;
    }

    public void setLeftExtend(float leftExtend) {
        this.leftExtend = leftExtend;
    }

    public float getRightExtend() {
        return rightExtend;
    }

    public void setRightExtend(float rightExtend) {
        this.rightExtend = rightExtend;
    }

    public int getPlanMode() {
        return planMode;
    }

    public void setPlanMode(int planMode) {
        this.planMode = planMode;
    }

    public boolean isHasCenterLine() {
        return hasCenterLine;
    }

    public void setHasCenterLine(boolean hasCenterLine) {
        this.hasCenterLine = hasCenterLine;
    }

    public int getPhotoFormat() {
        return photoFormat;
    }

    public void setPhotoFormat(int photoFormat) {
        this.photoFormat = photoFormat;
    }

    public boolean isEnableDewarping() {
        return enableDewarping;
    }

    public void setEnableDewarping(boolean enableDewarping) {
        this.enableDewarping = enableDewarping;
    }

    public boolean isEnableSingleLine() {
        return enableSingleLine;
    }

    public void setEnableSingleLine(boolean enableSingleLine) {
        this.enableSingleLine = enableSingleLine;
    }

    public int getAltitudeMode() {
        return altitudeMode;
    }

    public void setAltitudeMode(int altitudeMode) {
        this.altitudeMode = altitudeMode;
    }

    public float getRelativeDistance() {
        return relativeDistance;
    }

    public void setRelativeDistance(float relativeDistance) {
        this.relativeDistance = relativeDistance;
    }

    public int getFocusMode() {
        return focusMode;
    }

    public void setFocusMode(int focusMode) {
        this.focusMode = focusMode;
    }

    public int getEchoMode() {
        return echoMode;
    }

    public void setEchoMode(int echoMode) {
        this.echoMode = echoMode;
    }

    public int getSampleRate() {
        return sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getScanMode() {
        return scanMode;
    }

    public void setScanMode(int scanMode) {
        this.scanMode = scanMode;
    }

    public boolean isNeedVariegation() {
        return needVariegation;
    }

    public void setNeedVariegation(boolean needVariegation) {
        this.needVariegation = needVariegation;
    }

    public boolean isEnableCalibrate() {
        return enableCalibrate;
    }

    public void setEnableCalibrate(boolean enableCalibrate) {
        this.enableCalibrate = enableCalibrate;
    }

    public WaylineExitOnRCLostAction getLostAction() {
        return lostAction;
    }

    public void setLostAction(WaylineExitOnRCLostAction lostAction) {
        this.lostAction = lostAction;
    }

    public float getWgs84Altitude() {
        return wgs84Altitude;
    }

    public void setWgs84Altitude(float wgs84Altitude) {
        this.wgs84Altitude = wgs84Altitude;
    }

    public float getStripSecureTakeoffHeight() {
        return stripSecureTakeoffHeight;
    }

    public void setStripSecureTakeoffHeight(float stripSecureTakeoffHeight) {
        this.stripSecureTakeoffHeight = stripSecureTakeoffHeight;
    }

    public boolean isStripEnableDsm() {
        return stripEnableDsm;
    }

    public void setStripEnableDsm(boolean stripEnableDsm) {
        this.stripEnableDsm = stripEnableDsm;
    }

    public float getStripDsmAltitude() {
        return stripDsmAltitude;
    }

    public void setStripDsmAltitude(float stripDsmAltitude) {
        this.stripDsmAltitude = stripDsmAltitude;
    }

    public List<String> getStripDsmPath() {
        return stripDsmPath;
    }

    public void setStripDsmPath(List<String> stripDsmPath) {
        this.stripDsmPath = stripDsmPath;
    }

    public boolean isStripRealtimeSurfaceFollow() {
        return stripRealtimeSurfaceFollow;
    }

    public void setStripRealtimeSurfaceFollow(boolean stripRealtimeSurfaceFollow) {
        this.stripRealtimeSurfaceFollow = stripRealtimeSurfaceFollow;
    }

    public boolean isStripInclineClimbEnable() {
        return stripInclineClimbEnable;
    }

    public void setStripInclineClimbEnable(boolean stripInclineClimbEnable) {
        this.stripInclineClimbEnable = stripInclineClimbEnable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        StripWaylineModel model = (StripWaylineModel) o;

        if (altitude != model.altitude) return false;
        if (Float.compare(model.speed, speed) != 0) return false;
        if (Float.compare(model.takeoffSpeed, takeoffSpeed) != 0) return false;
        if (overlapH != model.overlapH) return false;
        if (overlapW != model.overlapW) return false;
        if (id != null ? !id.equals(model.id) : model.id != null) return false;
        if (actionOnFinish != model.actionOnFinish) return false;
        if (type != model.type) return false;
        if (photoMode != model.photoMode) return false;
        if (cutLength != model.cutLength) return false;
        if (leftExtend != model.leftExtend) return false;
        if (rightExtend != model.rightExtend) return false;
        if (planMode != model.planMode) return false;
        if (hasCenterLine != model.hasCenterLine) return false;
        if(startPoints == null){
            if(model.startPoints != null){
                return false;
            }
        }
        if(startPoints != null){
            if(!startPoints.equals(model.startPoints)){
                return false;
            }
        }
        if (photoFormat != model.photoFormat) return false;
        if (enableDewarping != model.enableDewarping) return false;
        if (enableSingleLine != model.enableSingleLine) return false;
        if (altitudeMode != model.altitudeMode) return false;
        if (relativeDistance != model.relativeDistance) return false;
        if (focusMode != model.focusMode) return false;
        if (echoMode != model.echoMode) return false;
        if (sampleRate != model.sampleRate) return false;
        if (scanMode != model.scanMode) return false;
        if (needVariegation != model.needVariegation) return false;
        if (enableCalibrate != model.enableCalibrate) return false;
        if (stripInclineClimbEnable != model.stripInclineClimbEnable) return false;
        if (Float.compare(model.stripSecureTakeoffHeight, stripSecureTakeoffHeight) != 0) return false;
        return camera != null ? camera.equals(model.camera) : model.camera == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (altitude != +0.0f ? Float.floatToIntBits(altitude) : 0);
        result = 31 * result + (speed != +0.0f ? Float.floatToIntBits(speed) : 0);
        result = 31 * result + (takeoffSpeed != +0.0f ? Float.floatToIntBits(takeoffSpeed) : 0);
        result = 31 * result + overlapH;
        result = 31 * result + overlapW;
        result = 31 * result + (actionOnFinish != null ? actionOnFinish.hashCode() : 0);
        result = 31 * result + (type != null ? type.hashCode() : 0);
        result = 31 * result + (camera != null ? camera.hashCode() : 0);
        result = 31 * result + photoMode;
        result = 31 * result + (cutLength != +0.0f ? Float.floatToIntBits(cutLength) : 0);
        result = 31 * result + (leftExtend != +0.0f ? Float.floatToIntBits(leftExtend) : 0);
        result = 31 * result + (rightExtend != +0.0f ? Float.floatToIntBits(rightExtend) : 0);
        result = 31 * result + planMode;
        result = 31 * result + (hasCenterLine ? 1 : 0);
        result = 31 * result + (startPoints != null ? startPoints.hashCode() : 0);
        result = 31 * result + photoFormat;
        result = 31 * result + (enableDewarping ? 1 : 0);
        result = 31 * result + (enableSingleLine ? 1 : 0);
        result = 31 * result + altitudeMode;
        result = 31 * result + (relativeDistance != +0.0f ? Float.floatToIntBits(relativeDistance) : 0);
        result = 31 * result + focusMode;
        result = 31 * result + echoMode;
        result = 31 * result + sampleRate;
        result = 31 * result + scanMode;
        result = 31 * result + (needVariegation ? 1 : 0);
        result = 31 * result + (enableCalibrate ? 1 : 0);
        result = 31 * result + (stripInclineClimbEnable ? 1 : 0);
        result = 31 * result + (stripSecureTakeoffHeight != +0.0f ? Float.floatToIntBits(stripSecureTakeoffHeight) : 0);
        return result;
    }

    @Override
    public StripWaylineModel clone() {
        StripWaylineModel model;
        try {
            model = (StripWaylineModel) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        if (camera != null) {
            model.setCamera(camera.clone());
        }
        if(startPoints != null){
            model.setStartPoints(startPoints);
        }
        return model;
    }

    public StripWaylineModel() {
    }

}
