package com.dji.industry.pilot.data.cache.model

import com.dji.wpmzsdk.common.utils.kml.model.WaypointActionType


/**
 * Description :
 *
 * @filename : WaypointActionModelGreenDao
 * @author : devin.xu
 * @time : 2022/12/1
 *
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
class WaypointActionModelGreenDao {

    var index = 0

    var actionType: WaypointActionType? = null

    /**
     * 悬停，单位 ms
     * 云台俯仰角，单位度
     * 云台偏航角，单位度
     * 相机变焦，单位 mm
     * 飞行器偏航角，单位度
     */
    var param = 0

    var accuracy = 0

    var cameraIndex = 0

    var payloadType = 0

    var payloadIndex = 0

    var preciseInfoName: String? = null

    var mediaPathName: String? = null

    fun getRealParam(): Float {
        return if (accuracy != 0) {
            (param / Math.pow(10.0, accuracy.toDouble())).toFloat()
        } else {
            param.toFloat()
        }
    }
}