package com.dji.wpmzsdk.common.utils.kml.model;



/**
 * Description :
 * 航线飞机类型，区分不同航线能力
 *
 * @author : devin.xu
 * @filename : WaypointDroneType
 * @time : 2019-07-25
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public enum WaypointDroneType {

    /**
     * 430飞机
     */
    PM430(0, ProductType.PM430),

    /**
     * Phantom 4 RTK
     */
    P4R(1, ProductType.P4R),

    /**
     * 其他
     */
    COMMON(2, ProductType.UNKNOWN),

    /**
     * 320: Matrice 30 RTK
     */
    PM320(3, ProductType.PM320),

    /**
     * 320: Matrice 30 T RTK
     */
    PM320_T_RTK(4, ProductType.PM320),
    WM265_E(5, ProductType.WM265),
    WM265_T(6, ProductType.WM265),
    WM265_M(7, ProductType.WM265),

    /**
     * 431飞机
     */
    PM431(8, ProductType.PM431);

    private final int value;
    private final ProductType productType;

    WaypointDroneType(int value, ProductType productType) {
        this.value = value;
        this.productType = productType;
    }

    public int value() {
        return value;
    }

    public ProductType getProductType() {
        return productType;
    }

    public static WaypointDroneType find(int value) {
        WaypointDroneType result = PM430;
        WaypointDroneType[] values = values();
        for (int i = 0; i < values.length; i++) {
            if (values[i].value == value) {
                result = values[i];
                break;
            }
        }
        return result;
    }
}
