package com.dji.wpmzsdk.common.utils.kml.model;
/*
 *   WWWWWW||WWWWWW
 *    W W W||W W W
 *         ||
 *       ( OO )__________
 *        /  |           \
 *       /o o|    DJI     \
 *       \___/||_||__||_|| **
 *            || ||  || ||
 *           _||_|| _||_||
 *          (__|__|(__|__|
 *
 * Copyright (c) 2017, DJI All Rights Reserved.
 */


import com.dji.wpmzsdk.common.utils.kml.CollectionUtil;
import com.dji.wpmzsdk.common.utils.kml.mission.MissionInfoModel;
import com.dji.wpmzsdk.common.utils.kml.transfrom.MissionTransformData;

import java.util.List;
import java.util.Objects;

/**
 * <p>Description:</p>
 *
 * @author create at 2018/7/2 下午10:04 by daniel for dji-pilot
 * @version v1.0
 */
public class WaypointMissionModel implements Cloneable {

    private Long id;
    private MissionInfoModel missionInfo;
    private WaylineModel wayline;
    private List<WaypointModel> waypoints;
    private MissionTransformData transformData;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MissionInfoModel getMissionInfo() {
        return missionInfo;
    }

    public void setMissionInfo(MissionInfoModel missionInfo) {
        this.missionInfo = missionInfo;
    }

    public WaylineModel getWayline() {
        return wayline;
    }

    public void setWayline(WaylineModel wayline) {
        this.wayline = wayline;
    }

    public List<WaypointModel> getWaypoints() {
        return waypoints;
    }

    public void setWaypoints(List<WaypointModel> waypoints) {
        this.waypoints = waypoints;
    }

    public MissionTransformData getTransformData() {
        return transformData;
    }

    public void setTransformData(MissionTransformData transformData) {
        this.transformData = transformData;
    }


    @Override
    public WaypointMissionModel clone() {
        WaypointMissionModel model;
        try {
            model = (WaypointMissionModel) super.clone();
        } catch (CloneNotSupportedException e) {
            //won't happen
            e.printStackTrace();
            return null;
        }
        if (wayline != null) {
            model.setWayline(wayline.clone());
        }
        if (missionInfo != null) {
            model.setMissionInfo(missionInfo.clone());
        }
        model.setWaypoints(CollectionUtil.transform(waypoints, WaypointModel::clone));
        return model;
    }

    public WaypointMissionModel() {

    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        WaypointMissionModel that = (WaypointMissionModel) o;
        return Objects.equals(id, that.id)
                && Objects.equals(missionInfo, that.missionInfo)
                && Objects.equals(wayline, that.wayline)
                && Objects.equals(waypoints, that.waypoints);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, missionInfo, wayline, waypoints);
    }
}
