package com.dji.wpmzsdk.common.utils.kml.transfrom;

import java.util.Objects;

import dji.sdk.wpmz.value.mission.WaylineAltitudeMode;

/**
 * Description :
 *
 * @author : devin.xu
 * @filename : MappingAltitudeModeTransform
 * @time : 2020/11/30
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public class MappingAltitudeModeTransform implements ModelTransform<Integer, WaylineAltitudeMode> {

    public static final Integer RELATIVE = 0;
    public static final Integer ABSOLUTE = 1;

    @Override
    public WaylineAltitudeMode transFrom(Integer integer) {
        if (Objects.equals(ABSOLUTE, integer)) {
            return WaylineAltitudeMode.EGM96;
        } else {
            return WaylineAltitudeMode.RELATIVE_TO_START_POINT;
        }
    }

    @Override
    public Integer transTo(WaylineAltitudeMode waylineAltitudeMode) {
        if (waylineAltitudeMode == WaylineAltitudeMode.EGM96) {
            return ABSOLUTE;
        } else {
            return RELATIVE;
        }
    }
}
