package com.dji.industry.pilot.mission.transfrom

import com.dji.wpmzsdk.common.utils.kml.transfrom.ModelTransform
import dji.sdk.wpmz.value.mission.WaylinePayloadFocusMode

/**
 * Description :
 *
 * @filename : MappingFocusModeTransform
 * @author : devin.xu
 * @time : 2021/9/15
 *
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
class MappingFocusModeTransform : ModelTransform<Int, WaylinePayloadFocusMode> {

    /**
     * 对焦模式： 首航点自动对焦 / 标定值对焦
     */
    val AUTO_FOCUS = 0
    val CALI_FOCUS = 1

    override fun transFrom(focusMode: Int): WaylinePayloadFocusMode {
        return if (focusMode == AUTO_FOCUS) WaylinePayloadFocusMode.FIRST_POINT else WaylinePayloadFocusMode.CUSTOM
    }

    override fun transTo(focusMode: WaylinePayloadFocusMode): Int {
        return if (focusMode == WaylinePayloadFocusMode.FIRST_POINT) AUTO_FOCUS else CALI_FOCUS
    }


}