package com.dji.wpmzsdk.common.utils.kml.transfrom;

/**
 * Description :
 *
 * @author : devin.xu
 * @filename : StripPlanModeTransform
 * @time : 2020/11/26
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public class StripPlanModeTransform implements ModelTransform<Integer, Boolean> {

    private static final Integer PLAN_MODE_EFFICIENT = 0;
    private static final Integer PLAN_MODE_FULL = 1;

    @Override
    public Boolean transFrom(Integer integer) {
        if (PLAN_MODE_FULL.equals(integer)) {
            return Boolean.TRUE;
        } else {
            return Boolean.FALSE;
        }
    }

    @Override
    public Integer transTo(Boolean boundOptimize) {
        if (boundOptimize) {
            return PLAN_MODE_FULL;
        } else {
            return PLAN_MODE_EFFICIENT;
        }
    }
}
