package com.dji.wpmzsdk.common.utils.kml.transfrom;



import com.dji.wpmzsdk.common.utils.kml.model.PayloadConfigInfoModel;

import dji.sdk.wpmz.value.mission.WaylinePayloadReturnMode;


/**
 * Description :
 *
 * @author : devin.xu
 * @filename : WaylineEchoModeTransform
 * @time : 2021/5/19
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public class WaylineEchoModeTransform implements ModelTransform<Integer, WaylinePayloadReturnMode> {

	@Override
	public WaylinePayloadReturnMode transFrom(Integer echoMode) {
		switch (echoMode) {
			case PayloadConfigInfoModel.ECHO_MODE_SINGLE_FIRST:
				return WaylinePayloadReturnMode.SINGLE_RETURN_FIRST;
			case PayloadConfigInfoModel.ECHO_MODE_SINGLE_STRONG:
				return WaylinePayloadReturnMode.SINGLE_RETURN_STRONGEST;
			case PayloadConfigInfoModel.ECHO_MODE_DOUBLE:
				return WaylinePayloadReturnMode.DUAL_RETURN;
			case PayloadConfigInfoModel.ECHO_MODE_TREBLE:
				return WaylinePayloadReturnMode.TRIPLE_RETURN;
			default:
				return WaylinePayloadReturnMode.SINGLE_RETURN_STRONGEST;
		}
	}

	@Override
	public Integer transTo(WaylinePayloadReturnMode waylinePayloadReturnMode) {
		switch (waylinePayloadReturnMode) {
			case SINGLE_RETURN_FIRST:
				return PayloadConfigInfoModel.ECHO_MODE_SINGLE_FIRST;
			case SINGLE_RETURN_STRONGEST:
				return PayloadConfigInfoModel.ECHO_MODE_SINGLE_STRONG;
			case DUAL_RETURN:
				return PayloadConfigInfoModel.ECHO_MODE_DOUBLE;
			case TRIPLE_RETURN:
				return PayloadConfigInfoModel.ECHO_MODE_TREBLE;
			default:
				return PayloadConfigInfoModel.ECHO_MODE_SINGLE_STRONG;
		}
	}
}
