package com.dji.wpmzsdk.common.utils.kml.transfrom;

import java.util.Objects;

import dji.sdk.wpmz.value.mission.WaylinePayloadFocusMode;


/**
 * Description :
 *
 * @author : devin.xu
 * @filename : WaylineMappingFocusModeTransform
 * @time : 2021/5/19
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public class WaylineMappingFocusModeTransform implements ModelTransform<Integer, WaylinePayloadFocusMode> {

	/**
	 * 对焦模式： 首航点自动对焦 / 标定值对焦
	 */
	public static final int AUTO_FOCUS = 0;
	public static final int CALI_FOCUS = 1;

	@Override
	public WaylinePayloadFocusMode transFrom(Integer mode) {
		if (Objects.equals(mode, AUTO_FOCUS)) {
			return WaylinePayloadFocusMode.FIRST_POINT;
		} else if (Objects.equals(mode, CALI_FOCUS)) {
			return WaylinePayloadFocusMode.CUSTOM;
		}
		return WaylinePayloadFocusMode.FIRST_POINT;
	}

	@Override
	public Integer transTo(WaylinePayloadFocusMode waylinePayloadFocusMode) {
		if (waylinePayloadFocusMode == WaylinePayloadFocusMode.FIRST_POINT) {
			return AUTO_FOCUS;
		} else if (waylinePayloadFocusMode == WaylinePayloadFocusMode.CUSTOM) {
			return CALI_FOCUS;
		}
		return AUTO_FOCUS;
	}
}
