package com.dji.wpmzsdk.common.utils.kml.transfrom;


import com.dji.wpmzsdk.common.utils.kml.mission.RTKReferenceStationSource;

import dji.sdk.wpmz.value.mission.WaylinePositioningType;

/**
 * Description :
 *
 * @author : devin.xu
 * @filename : WaylineRtkTypeTransform
 * @time : 2020/11/25
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public class WaylineRtkTypeTransform implements ModelTransform<RTKReferenceStationSource, WaylinePositioningType> {
    @Override
    public WaylinePositioningType transFrom(RTKReferenceStationSource rtkReferenceStationSource) {
        if (rtkReferenceStationSource != null) {
            switch (rtkReferenceStationSource) {
                case BASE_STATION:
                    return WaylinePositioningType.RTK_BASE_STATION;
                case QX_NETWORK_SERVICE:
                    return WaylinePositioningType.RTK_QIANXUN;
                case DPS:
                case CUSTOM_NETWORK_SERVICE:
                    // TODO eleven.chen 这里航线类型需要向@ya.li
                case NTRIP_NETWORK_SERVICE:
                    return WaylinePositioningType.RTK_CUSTOM;
                default:
                    return WaylinePositioningType.GPS;
            }
        }
        return WaylinePositioningType.GPS;
    }

    @Override
    public RTKReferenceStationSource transTo(WaylinePositioningType waylinePositioningType) {
        if (waylinePositioningType != null) {
            // TODO @eleven.chen 这里需要向@ya.li确认是否要新增类型
            switch (waylinePositioningType) {
                case RTK_CUSTOM:
                    return RTKReferenceStationSource.CUSTOM_NETWORK_SERVICE;
                case RTK_QIANXUN:
                    return RTKReferenceStationSource.QX_NETWORK_SERVICE;
                case RTK_BASE_STATION:
                    return RTKReferenceStationSource.BASE_STATION;
                default:
                    return RTKReferenceStationSource.NONE;
            }
        }
        return RTKReferenceStationSource.NONE;
    }
}
