package com.dji.wpmzsdk.common.utils.kml.transfrom;

import com.dji.wpmzsdk.common.utils.kml.model.ScanMode;

import java.util.Objects;


import dji.sdk.wpmz.value.mission.WaylinePayloadScanningMode;

/**
 * Description :
 *
 * @author : devin.xu
 * @filename : WaylineScanModeTransform
 * @time : 2021/5/19
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public class WaylineScanModeTransform implements ModelTransform<Integer, WaylinePayloadScanningMode> {

	@Override
	public WaylinePayloadScanningMode transFrom(Integer mode) {
		if (Objects.equals(mode, ScanMode.REPEAT.value())) {
			return WaylinePayloadScanningMode.REPETITIVE;
		} else if (Objects.equals(mode, ScanMode.NON_REPEAT.value())) {
			return WaylinePayloadScanningMode.NON_REPETITIVE;
		}
		return WaylinePayloadScanningMode.REPETITIVE;
	}

	@Override
	public Integer transTo(WaylinePayloadScanningMode mode) {
		if (mode == WaylinePayloadScanningMode.REPETITIVE) {
			return ScanMode.REPEAT.value();
		} else if (mode == WaylinePayloadScanningMode.NON_REPETITIVE) {
			return ScanMode.NON_REPEAT.value();
		}
		return ScanMode.REPEAT.value();
	}
}
